#ifndef morpheo_behavioural_core_multi_execute_loop_execute_loop_network_read_unit_to_execution_unit_Parameters_h
#define morpheo_behavioural_core_multi_execute_loop_execute_loop_network_read_unit_to_execution_unit_Parameters_h

/*
 * $Id: Parameters.h 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Common/include/Debug.h"
#include "Behavioural/include/Parameters.h"
#include "Behavioural/include/Types.h"
#include "Behavioural/include/Identification.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace network {
namespace read_unit_to_execution_unit {


  class Parameters : public morpheo::behavioural::Parameters
  {
    //-----[ fields ]------------------------------------------------------------
  public : uint32_t    _nb_read_unit           ;
  public : uint32_t  * _nb_read_unit_port      ;//[nb_read_unit]
  public : uint32_t    _nb_execute_unit        ;
  public : uint32_t  * _nb_execute_unit_port   ;//[nb_execute_unit]
  public : uint32_t    _nb_context             ;
  public : uint32_t    _nb_front_end           ;
  public : uint32_t    _nb_ooo_engine          ;
  public : uint32_t    _nb_packet              ;
//public : uint32_t    _size_general_data      ;
//public : uint32_t    _size_special_data      ;
  public : uint32_t    _nb_general_register    ;
  public : uint32_t    _nb_special_register    ;
//public : uint32_t    _size_store_queue       ;
//public : uint32_t    _size_load_queue        ;
  public : Tpriority_t _priority               ;
  public : bool    *** _table_routing          ; //[nb_read_unit][nb_execute_unit][nb_execute_unit_port]
  public : bool     ** _table_execute_type     ; //[nb_execute_unit][nb_type]
  public : bool     ** _table_execute_thread   ; //[nb_execute_unit][nb_thread]

  public : uint32_t    _max_nb_read_unit_port  ;
  public : uint32_t    _max_nb_execute_unit_port;
//public : uint32_t    _size_context_id        ;
//public : uint32_t    _size_front_end_id      ;
//public : uint32_t    _size_ooo_engine_id     ;
//public : uint32_t    _size_packet_id         ;
//public : uint32_t    _size_general_register  ;
//public : uint32_t    _size_special_register  ;

//public : bool        _have_port_context_id   ;
//public : bool        _have_port_front_end_id ;
//public : bool        _have_port_ooo_engine_id;
//public : bool        _have_port_packet_id    ;
//public : bool        _have_port_load_queue_ptr;

  public : uint32_t    _nb_thread              ;
  public : uint32_t    _nb_load_store_unit     ;
  public : uint32_t    _nb_functionnal_unit    ;

    //-----[ methods ]-----------------------------------------------------------
  public : Parameters  (uint32_t    nb_read_unit           ,
			uint32_t  * nb_read_unit_port      ,
			uint32_t    nb_execute_unit        ,
			uint32_t  * nb_execute_unit_port   ,
			uint32_t    nb_context             ,
			uint32_t    nb_front_end           ,
			uint32_t    nb_ooo_engine          ,
			uint32_t    nb_packet              ,
			uint32_t    size_general_data      ,
			uint32_t    size_special_data      ,
			uint32_t    nb_general_register    ,
			uint32_t    nb_special_register    ,
			uint32_t    size_store_queue       ,
			uint32_t    size_load_queue        ,
			Tpriority_t priority               ,
			bool    *** table_routing          ,
			bool     ** table_execute_type     ,
			bool     ** table_execute_thread   ,
                        bool        is_toplevel=false      );
//   public : Parameters  (Parameters & param) ;
  public : ~Parameters () ;

  public :        void            copy       (void);

  public :        Parameters_test msg_error  (void);

  public :        std::string   print      (uint32_t depth);
  public : friend std::ostream& operator<< (std::ostream& output_stream,
					    morpheo::behavioural::core::multi_execute_loop::execute_loop::network::read_unit_to_execution_unit::Parameters & x);
  };

}; // end namespace read_unit_to_execution_unit
}; // end namespace network
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              

#endif
