#ifndef ENVIRONMENT_CACHE_CACHE_MULTILEVEL_PARAMETERS_H
#define ENVIRONMENT_CACHE_CACHE_MULTILEVEL_PARAMETERS_H

#include <iostream>
#include <math.h>

#include "Cache_OneLevel_Parameters.h"

namespace environment {
namespace cache {
namespace cache_multilevel {

  class Parameters
  {
  public : uint32_t nb_level     ;
  public : uint32_t nb_port      ;
    
  public : cache_onelevel::Parameters ** param_cache;
    
  public : Parameters (uint32_t   nb_level     ,
		       uint32_t   nb_port      ,
		       uint32_t * nb_line      ,
		       uint32_t * size_line    ,
		       uint32_t * size_word    ,
		       uint32_t * associativity,
		       uint32_t * hit_latence  ,
		       uint32_t * miss_penality)
    {
      this->nb_level = nb_level;
      this->nb_port  = nb_port ;

      param_cache = new cache_onelevel::Parameters * [nb_level];
      for (uint32_t i=0; i<nb_level; i++)
	param_cache [i] = new cache_onelevel::Parameters
	  (nb_port          ,
	   nb_line       [i],
	   size_line     [i],
	   size_word     [i],
	   associativity [i],
	   hit_latence   [i],
	   miss_penality [i]);
    }
    
  public : ~Parameters (void)
    {
      for (uint32_t i=0; i<nb_level; i++)
	delete param_cache [i];
      delete [] param_cache;

    }

  public : friend std::ostream& operator<< (std::ostream& output, const Parameters &x)
    {
      
      return output;
    }

  public : std::string print (uint32_t depth)
    {
      std::string tab (depth,'\t');
      std::stringstream str;

      str << tab << "* Nb Level              : " << nb_level << std::endl;

      for (uint32_t i=0; i<nb_level; i++)
	str << tab << "  * Level " << "Level " << i << std::endl
	    << param_cache [i]->print(depth+1) << std::endl;
      
      return str.str();
    }
    
    
    friend std::ostream& operator<< (std::ostream& output, Parameters &x)
    {
      output << x.print(0);
      return output;
    }

  };

};
};
};
#endif
