/*
 * $Id: Instance_test.cpp 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Configuration/include/Instance.h"

namespace morpheo {
namespace behavioural {
namespace configuration {

#undef  FUNCTION
#define FUNCTION "Instance::test"
  void Instance::test (std::string type,
                       std::string value)
  {
    log_begin(Configuration,FUNCTION);

    // Test the parameter :
    //   * name is correct
    //   * value is correct
    
    _generator->test(type, value);
    
    log_end(Configuration,FUNCTION);
  }

#undef  FUNCTION
#define FUNCTION "Instance::test"
  void Instance::test (std::string type,
                       std::string father_name,
                       bool        father_is_src,
                       bool        father_is_dest)
  {
    log_begin(Configuration,FUNCTION);

    //   * name is correct
    //   * if not have_src , test if src  is correct
    //   * if not have_dest, test if dest is correct
    _generator->test(type,
                     father_name,
                     father_is_src,
                     father_is_dest);
    
    log_end(Configuration,FUNCTION);
  }

#undef  FUNCTION
#define FUNCTION "Instance::test"

  void Instance::test (std::string link,
                       std::vector<std::string> & vect,
                       uint32_t nb_elt)
  {
    log_begin(Configuration,FUNCTION);
    
    if (vect.size() == 0)
      for (uint32_t i=0; i<nb_elt; ++i)
        vect.push_back("0"); // default to link
    else
      if (vect.size() != nb_elt)
        throw ERRORMORPHEO(FUNCTION,toString(_("The destination of link \"%s\" must an index on %d elements.\n"),link.c_str(),nb_elt));

    log_end(Configuration,FUNCTION);
  }

  /*
#undef  FUNCTION
#define FUNCTION "Instance::test"
  void Instance::test (std::string component,
                       uint32_t    nb_component)
  {
    log_begin(Configuration,FUNCTION);

    test (component,nb_component,_list_components);

    log_end(Configuration,FUNCTION);
  }

#undef  FUNCTION
#define FUNCTION "Instance::test"
  void Instance::test (std::string         component,
                       uint32_t            nb_component,
                       list_components_t * list_components)
  {
    log_begin(Configuration,FUNCTION);

    // ........................


    for (list_components_t::iterator it1=list_components->begin();
         it1!=list_components->end();
         ++it1)
      for (list_instances_t::iterator it2=it1->second.begin();
           it2!=it1->second.end();
           ++it2)
      test (component,nb_component,it2->second->_list_components);
    
    log_end(Configuration,FUNCTION);
  }
  */  

}; // end namespace configuration
}; // end namespace behavioural
}; // end namespace morpheo              
