/*
 * $Id: test.cpp 98 2008-12-31 10:18:08Z rosiere $
 *
 * [Description ]
 * 
 * Test
 */

#define NB_ITERATION  16
#define CYCLE_MAX     (128*NB_ITERATION)

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Write_unit/Write_unit/Execute_queue/SelfTest/include/test.h"
#include "Common/include/Test.h"
#include "Behavioural/include/Allocation.h"
#include "Common/include/BitManipulation.h"

  class entry_t
  {
  public  : Tcontext_t         _context_id   ;
  public  : Tcontext_t         _front_end_id ;
  public  : Tcontext_t         _ooo_engine_id;
  public  : Tpacket_t          _packet_id    ;
//public  : Toperation_t       _operation    ;
//public  : Ttype_t            _type         ;
  public  : Tspecial_data_t    _flags        ;
  public  : Texception_t       _exception    ;
  public  : Tcontrol_t         _no_sequence  ;
  public  : Tgeneral_data_t    _address      ;
  public  : Tgeneral_data_t    _data         ;
    
  public  : entry_t (Tcontext_t         context_id   ,
		     Tcontext_t         front_end_id ,
		     Tcontext_t         ooo_engine_id,
		     Tpacket_t          packet_id    ,
		     //Toperation_t       operation    ,
		     //Ttype_t            type         ,
		     Tspecial_data_t    flags        ,
		     Texception_t       exception    ,
		     Tcontrol_t         no_sequence  ,
		     Tgeneral_data_t    address      ,
		     Tgeneral_data_t    data         )
    {
      _context_id    = context_id   ;
      _front_end_id  = front_end_id ;
      _ooo_engine_id = ooo_engine_id;
      _packet_id     = packet_id    ;
    //_operation     = operation    ;
    //_type          = type         ;
      _flags         = flags        ;
      _exception     = exception    ;
      _no_sequence   = no_sequence  ;
      _address       = address      ;
      _data          = data         ;
    };

    friend std::ostream& operator<< (std::ostream& output_stream,
				     entry_t & x)
    {
      output_stream << " * _context_id    : " << toString(x._context_id   ) << std::endl
		    << " * _front_end_id  : " << toString(x._front_end_id ) << std::endl
		    << " * _ooo_engine_id : " << toString(x._ooo_engine_id) << std::endl
		    << " * _packet_id     : " << toString(x._packet_id    ) << std::endl
		  //<< " * _operation     : " << toString(x._operation    ) << std::endl
		  //<< " * _type          : " << toString(x._type         ) << std::endl
		    << " * _flags         : " << toString(x._flags        ) << std::endl
		    << " * _exception     : " << toString(x._exception    ) << std::endl
		    << " * _no_sequence   : " << toString(x._no_sequence  ) << std::endl
		    << " * _address       : " << toString(x._address      ) << std::endl
		    << " * _data          : " << toString(x._data         ) << std::endl;

      return output_stream;
    }
  };




void test (string name,
	   morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_write_unit::write_unit::execute_queue::Parameters * _param)
{
  msg(_("<%s> : Simulation SystemC.\n"),name.c_str());

#ifdef STATISTICS
  morpheo::behavioural::Parameters_Statistics * _parameters_statistics = new morpheo::behavioural::Parameters_Statistics (5,50);
#endif

  Tusage_t _usage = USE_ALL;

//   _usage = usage_unset(_usage,USE_SYSTEMC              );
//   _usage = usage_unset(_usage,USE_VHDL                 );
//   _usage = usage_unset(_usage,USE_VHDL_TESTBENCH       );
//   _usage = usage_unset(_usage,USE_VHDL_TESTBENCH_ASSERT);
//   _usage = usage_unset(_usage,USE_POSITION             );
//   _usage = usage_unset(_usage,USE_STATISTICS           );
//   _usage = usage_unset(_usage,USE_INFORMATION          );

  Execute_queue * _Execute_queue = new Execute_queue 
    (name.c_str(),
#ifdef STATISTICS
     _parameters_statistics,
#endif
     _param,
     _usage);
  
#ifdef SYSTEMC
  /*********************************************************************
   * Dclarations des signaux
   *********************************************************************/
  string rename;

  sc_clock              *  in_CLOCK  = new sc_clock ("clock", 1.0, 0.5);	 
  sc_signal<Tcontrol_t> *  in_NRESET = new sc_signal<Tcontrol_t> ("NRESET");

  ALLOC_SC_SIGNAL ( in_EXECUTE_QUEUE_IN_VAL           ," in_EXECUTE_QUEUE_IN_VAL"           , Tcontrol_t        );
  ALLOC_SC_SIGNAL (out_EXECUTE_QUEUE_IN_ACK           ,"out_EXECUTE_QUEUE_IN_ACK"           , Tcontrol_t        );
  ALLOC_SC_SIGNAL ( in_EXECUTE_QUEUE_IN_CONTEXT_ID    ," in_EXECUTE_QUEUE_IN_CONTEXT_ID"    , Tcontext_t        );
  ALLOC_SC_SIGNAL ( in_EXECUTE_QUEUE_IN_FRONT_END_ID  ," in_EXECUTE_QUEUE_IN_FRONT_END_ID"  , Tcontext_t        );
  ALLOC_SC_SIGNAL ( in_EXECUTE_QUEUE_IN_OOO_ENGINE_ID ," in_EXECUTE_QUEUE_IN_OOO_ENGINE_ID" , Tcontext_t        );
  ALLOC_SC_SIGNAL ( in_EXECUTE_QUEUE_IN_PACKET_ID     ," in_EXECUTE_QUEUE_IN_PACKET_ID"     , Tpacket_t         );
//ALLOC_SC_SIGNAL ( in_EXECUTE_QUEUE_IN_OPERATION     ," in_EXECUTE_QUEUE_IN_OPERATION"     , Toperation_t      );
//ALLOC_SC_SIGNAL ( in_EXECUTE_QUEUE_IN_TYPE          ," in_EXECUTE_QUEUE_IN_TYPE"          , Ttype_t           );
  ALLOC_SC_SIGNAL ( in_EXECUTE_QUEUE_IN_FLAGS         ," in_EXECUTE_QUEUE_IN_FLAGS"         , Tspecial_data_t   );
  ALLOC_SC_SIGNAL ( in_EXECUTE_QUEUE_IN_EXCEPTION     ," in_EXECUTE_QUEUE_IN_EXCEPTION"     , Texception_t      );
  ALLOC_SC_SIGNAL ( in_EXECUTE_QUEUE_IN_NO_SEQUENCE   ," in_EXECUTE_QUEUE_IN_NO_SEQUENCE"   , Tcontrol_t        );
  ALLOC_SC_SIGNAL ( in_EXECUTE_QUEUE_IN_ADDRESS       ," in_EXECUTE_QUEUE_IN_ADDRESS"       , Taddress_t        );
  ALLOC_SC_SIGNAL ( in_EXECUTE_QUEUE_IN_DATA          ," in_EXECUTE_QUEUE_IN_DATA"          , Tgeneral_data_t   );
  ALLOC_SC_SIGNAL (out_EXECUTE_QUEUE_OUT_VAL          ,"out_EXECUTE_QUEUE_OUT_VAL"          , Tcontrol_t        );
  ALLOC_SC_SIGNAL ( in_EXECUTE_QUEUE_OUT_ACK          ," in_EXECUTE_QUEUE_OUT_ACK"          , Tcontrol_t        );
  ALLOC_SC_SIGNAL (out_EXECUTE_QUEUE_OUT_CONTEXT_ID   ,"out_EXECUTE_QUEUE_OUT_CONTEXT_ID"   , Tcontext_t        );
  ALLOC_SC_SIGNAL (out_EXECUTE_QUEUE_OUT_FRONT_END_ID ,"out_EXECUTE_QUEUE_OUT_FRONT_END_ID" , Tcontext_t        );
  ALLOC_SC_SIGNAL (out_EXECUTE_QUEUE_OUT_OOO_ENGINE_ID,"out_EXECUTE_QUEUE_OUT_OOO_ENGINE_ID", Tcontext_t        );
  ALLOC_SC_SIGNAL (out_EXECUTE_QUEUE_OUT_PACKET_ID    ,"out_EXECUTE_QUEUE_OUT_PACKET_ID"    , Tpacket_t         );
//ALLOC_SC_SIGNAL (out_EXECUTE_QUEUE_OUT_OPERATION    ,"out_EXECUTE_QUEUE_OUT_OPERATION"    , Toperation_t      );
//ALLOC_SC_SIGNAL (out_EXECUTE_QUEUE_OUT_TYPE         ,"out_EXECUTE_QUEUE_OUT_TYPE"         , Ttype_t           );
  ALLOC_SC_SIGNAL (out_EXECUTE_QUEUE_OUT_FLAGS        ,"out_EXECUTE_QUEUE_OUT_FLAGS"        , Tspecial_data_t   );
  ALLOC_SC_SIGNAL (out_EXECUTE_QUEUE_OUT_EXCEPTION    ,"out_EXECUTE_QUEUE_OUT_EXCEPTION"    , Texception_t      );
  ALLOC_SC_SIGNAL (out_EXECUTE_QUEUE_OUT_NO_SEQUENCE  ,"out_EXECUTE_QUEUE_OUT_NO_SEQUENCE"  , Tcontrol_t        );
  ALLOC_SC_SIGNAL (out_EXECUTE_QUEUE_OUT_ADDRESS      ,"out_EXECUTE_QUEUE_OUT_ADDRESS"      , Taddress_t        );
  ALLOC_SC_SIGNAL (out_EXECUTE_QUEUE_OUT_DATA         ,"out_EXECUTE_QUEUE_OUT_DATA"         , Tgeneral_data_t   );

  
  /********************************************************
   * Instanciation
   ********************************************************/
  
  msg(_("<%s> : Instanciation of _Execute_queue.\n"),name.c_str());

  (*(_Execute_queue->in_CLOCK))        (*(in_CLOCK));
  (*(_Execute_queue->in_NRESET))       (*(in_NRESET));

  INSTANCE_SC_SIGNAL (_Execute_queue,  in_EXECUTE_QUEUE_IN_VAL           );
  INSTANCE_SC_SIGNAL (_Execute_queue, out_EXECUTE_QUEUE_IN_ACK           );
  if (_param->_have_port_context_id)
  INSTANCE_SC_SIGNAL (_Execute_queue,  in_EXECUTE_QUEUE_IN_CONTEXT_ID    );
  if (_param->_have_port_front_end_id)
  INSTANCE_SC_SIGNAL (_Execute_queue,  in_EXECUTE_QUEUE_IN_FRONT_END_ID  );
  if (_param->_have_port_ooo_engine_id)
  INSTANCE_SC_SIGNAL (_Execute_queue,  in_EXECUTE_QUEUE_IN_OOO_ENGINE_ID );
  if (_param->_have_port_rob_ptr)
  INSTANCE_SC_SIGNAL (_Execute_queue,  in_EXECUTE_QUEUE_IN_PACKET_ID     );
//INSTANCE_SC_SIGNAL (_Execute_queue,  in_EXECUTE_QUEUE_IN_OPERATION     );
//INSTANCE_SC_SIGNAL (_Execute_queue,  in_EXECUTE_QUEUE_IN_TYPE          );
  INSTANCE_SC_SIGNAL (_Execute_queue,  in_EXECUTE_QUEUE_IN_FLAGS         );
  INSTANCE_SC_SIGNAL (_Execute_queue,  in_EXECUTE_QUEUE_IN_EXCEPTION     );
  INSTANCE_SC_SIGNAL (_Execute_queue,  in_EXECUTE_QUEUE_IN_NO_SEQUENCE   );
  INSTANCE_SC_SIGNAL (_Execute_queue,  in_EXECUTE_QUEUE_IN_ADDRESS       );
  INSTANCE_SC_SIGNAL (_Execute_queue,  in_EXECUTE_QUEUE_IN_DATA          );

  INSTANCE_SC_SIGNAL (_Execute_queue, out_EXECUTE_QUEUE_OUT_VAL          );
  INSTANCE_SC_SIGNAL (_Execute_queue,  in_EXECUTE_QUEUE_OUT_ACK          );
  if (_param->_have_port_context_id)
  INSTANCE_SC_SIGNAL (_Execute_queue, out_EXECUTE_QUEUE_OUT_CONTEXT_ID   );
  if (_param->_have_port_front_end_id)
  INSTANCE_SC_SIGNAL (_Execute_queue, out_EXECUTE_QUEUE_OUT_FRONT_END_ID );
  if (_param->_have_port_ooo_engine_id)
  INSTANCE_SC_SIGNAL (_Execute_queue, out_EXECUTE_QUEUE_OUT_OOO_ENGINE_ID);
  if (_param->_have_port_rob_ptr)
  INSTANCE_SC_SIGNAL (_Execute_queue, out_EXECUTE_QUEUE_OUT_PACKET_ID    );
//INSTANCE_SC_SIGNAL (_Execute_queue, out_EXECUTE_QUEUE_OUT_OPERATION    );
//INSTANCE_SC_SIGNAL (_Execute_queue, out_EXECUTE_QUEUE_OUT_TYPE         );
  INSTANCE_SC_SIGNAL (_Execute_queue, out_EXECUTE_QUEUE_OUT_FLAGS        );
  INSTANCE_SC_SIGNAL (_Execute_queue, out_EXECUTE_QUEUE_OUT_EXCEPTION    );
  INSTANCE_SC_SIGNAL (_Execute_queue, out_EXECUTE_QUEUE_OUT_NO_SEQUENCE  );
  INSTANCE_SC_SIGNAL (_Execute_queue, out_EXECUTE_QUEUE_OUT_ADDRESS      );
  INSTANCE_SC_SIGNAL (_Execute_queue, out_EXECUTE_QUEUE_OUT_DATA         );

  msg(_("<%s> : Start Simulation ............\n"),name.c_str());
    
  Time * _time = new Time();

  /********************************************************
   * Simulation - Begin
   ********************************************************/

  // Initialisation

  const uint32_t seed = 0;
//const uint32_t seed = static_cast<uint32_t>(time(NULL));

  const  int32_t percent_transaction_execute_queue_in  = 75;
  const  int32_t percent_transaction_execute_queue_out = 75;

  entry_t *       request [_param->_nb_packet];

  srand(seed);

  SC_START(0);
  LABEL("Initialisation");

  LABEL("Reset");
  in_NRESET->write(0);
  SC_START(5);
  in_NRESET->write(1);  

  LABEL("Loop of Test");

  for (uint32_t iteration=0; iteration<NB_ITERATION; iteration ++)
    {
      LABEL("Iteration %d",iteration);

      for (uint32_t i=0; i<_param->_nb_packet; i++)
	{
	  request [i] = new entry_t (range<Tcontext_t        >(rand(),_param->_size_context_id      ),
				     range<Tcontext_t        >(rand(),_param->_size_front_end_id    ),
				     range<Tcontext_t        >(rand(),_param->_size_ooo_engine_id   ),
				     i,
				   //range<Toperation_t      >(rand(),_param->_size_operation       ),
				   //range<Ttype_t           >(rand(),_param->_size_type            ),
				     range<Tspecial_data_t   >(rand(),_param->_size_special_data    ),
				     range<Texception_t      >(rand(),_param->_size_exception       ),
				     range<Tcontrol_t        >(rand(),1                             ),
				     range<Tgeneral_data_t   >(rand(),_param->_size_general_data    ),
				     range<Tgeneral_data_t   >(rand(),_param->_size_general_data    ));
	}

            uint32_t nb_request_in  = 0;
      uint32_t nb_request_out = 0;
      
      while (nb_request_out < _param->_nb_packet)
      {
	bool val = (((rand()%100)<percent_transaction_execute_queue_in) and
		    (nb_request_in < _param->_nb_packet));
	
	in_EXECUTE_QUEUE_IN_VAL          ->write(val);
	if (val)
	  {
	    in_EXECUTE_QUEUE_IN_CONTEXT_ID   ->write(request [nb_request_in]->_context_id   );
	    in_EXECUTE_QUEUE_IN_FRONT_END_ID ->write(request [nb_request_in]->_front_end_id );
	    in_EXECUTE_QUEUE_IN_OOO_ENGINE_ID->write(request [nb_request_in]->_ooo_engine_id);
	    in_EXECUTE_QUEUE_IN_PACKET_ID    ->write(request [nb_request_in]->_packet_id    );
	  //in_EXECUTE_QUEUE_IN_OPERATION    ->write(request [nb_request_in]->_operation    );
	  //in_EXECUTE_QUEUE_IN_TYPE         ->write(request [nb_request_in]->_type         );
	    in_EXECUTE_QUEUE_IN_FLAGS        ->write(request [nb_request_in]->_flags        );
	    in_EXECUTE_QUEUE_IN_EXCEPTION    ->write(request [nb_request_in]->_exception    );
	    in_EXECUTE_QUEUE_IN_NO_SEQUENCE  ->write(request [nb_request_in]->_no_sequence  );
	    in_EXECUTE_QUEUE_IN_ADDRESS      ->write(request [nb_request_in]->_address      );
	    in_EXECUTE_QUEUE_IN_DATA         ->write(request [nb_request_in]->_data         );
	  }
	in_EXECUTE_QUEUE_OUT_ACK         ->write((rand()%100)<percent_transaction_execute_queue_out);
	    
	SC_START(0);

	
	// ======================================================================
	// ======================================================================
	// ======================================================================
	if ( in_EXECUTE_QUEUE_IN_VAL->read() and
	    out_EXECUTE_QUEUE_IN_ACK->read())
	  {
	    LABEL(" * Accepted EXECUTE_QUEUE_IN  [%d]",nb_request_in);
// 	    std::cout << *request [nb_request_in] << std::endl;

	    nb_request_in ++;
	  }
	
	// ======================================================================
	// ======================================================================
	// ======================================================================
	if (out_EXECUTE_QUEUE_OUT_VAL->read() and
	     in_EXECUTE_QUEUE_OUT_ACK->read())
	  {
	    Tcontext_t packet;
	    if (_param->_have_port_rob_ptr)
	      packet = out_EXECUTE_QUEUE_OUT_PACKET_ID->read();
	    else
	      packet = 0;

	    LABEL(" * Accepted EXECUTE_QUEUE_OUT [%d]",packet);
// 	    std::cout << *request [packet] << std::endl;

	    if (_param->_have_port_context_id)
	    TEST(Tcontext_t     , out_EXECUTE_QUEUE_OUT_CONTEXT_ID   ->read(), request [packet]->_context_id   );
	    if (_param->_have_port_front_end_id)
	    TEST(Tcontext_t     , out_EXECUTE_QUEUE_OUT_FRONT_END_ID ->read(), request [packet]->_front_end_id );
	    if (_param->_have_port_ooo_engine_id)
	    TEST(Tcontext_t     , out_EXECUTE_QUEUE_OUT_OOO_ENGINE_ID->read(), request [packet]->_ooo_engine_id);
	  //TEST(Toperation_t   , out_EXECUTE_QUEUE_OUT_OPERATION    ->read(), request [packet]->_operation    );
	  //TEST(Ttype_t        , out_EXECUTE_QUEUE_OUT_TYPE         ->read(), request [packet]->_type         );
	    TEST(Tcontrol_t     , out_EXECUTE_QUEUE_OUT_FLAGS        ->read(), request [packet]->_flags        );
	    TEST(Texception_t   , out_EXECUTE_QUEUE_OUT_EXCEPTION    ->read(), request [packet]->_exception    );
	    TEST(Tcontrol_t     , out_EXECUTE_QUEUE_OUT_NO_SEQUENCE  ->read(), request [packet]->_no_sequence  );
	    TEST(Tgeneral_data_t, out_EXECUTE_QUEUE_OUT_ADDRESS      ->read(), request [packet]->_address      );
	    TEST(Tgeneral_data_t, out_EXECUTE_QUEUE_OUT_DATA         ->read(), request [packet]->_data         );

	    nb_request_out ++;
	  }

	SC_START(1);
      }
    }

  /********************************************************
   * Simulation - End
   ********************************************************/

  TEST_OK ("End of Simulation");
  delete _time;

  msg(_("<%s> : ............ Stop Simulation\n"),name.c_str());

  delete in_CLOCK;
  delete in_NRESET;

  delete     in_EXECUTE_QUEUE_IN_VAL           ;
  delete    out_EXECUTE_QUEUE_IN_ACK           ;
  delete     in_EXECUTE_QUEUE_IN_CONTEXT_ID    ;
  delete     in_EXECUTE_QUEUE_IN_FRONT_END_ID  ;
  delete     in_EXECUTE_QUEUE_IN_OOO_ENGINE_ID ;
  delete     in_EXECUTE_QUEUE_IN_PACKET_ID     ;
//delete     in_EXECUTE_QUEUE_IN_OPERATION     ;
//delete     in_EXECUTE_QUEUE_IN_TYPE          ;
  delete     in_EXECUTE_QUEUE_IN_FLAGS         ;
  delete     in_EXECUTE_QUEUE_IN_EXCEPTION     ;
  delete     in_EXECUTE_QUEUE_IN_NO_SEQUENCE   ;
  delete     in_EXECUTE_QUEUE_IN_ADDRESS       ;
  delete     in_EXECUTE_QUEUE_IN_DATA          ;

  delete    out_EXECUTE_QUEUE_OUT_VAL          ;
  delete     in_EXECUTE_QUEUE_OUT_ACK          ;
  delete    out_EXECUTE_QUEUE_OUT_CONTEXT_ID   ;
  delete    out_EXECUTE_QUEUE_OUT_FRONT_END_ID ;
  delete    out_EXECUTE_QUEUE_OUT_OOO_ENGINE_ID;
  delete    out_EXECUTE_QUEUE_OUT_PACKET_ID    ;
//delete    out_EXECUTE_QUEUE_OUT_OPERATION    ;
//delete    out_EXECUTE_QUEUE_OUT_TYPE         ;
  delete    out_EXECUTE_QUEUE_OUT_FLAGS        ;
  delete    out_EXECUTE_QUEUE_OUT_EXCEPTION    ;
  delete    out_EXECUTE_QUEUE_OUT_NO_SEQUENCE  ;
  delete    out_EXECUTE_QUEUE_OUT_ADDRESS      ;
  delete    out_EXECUTE_QUEUE_OUT_DATA         ;
#endif

  delete _Execute_queue;
#ifdef STATISTICS
  delete _parameters_statistics;
#endif
}
