/*
 * $Id: Parameters_print.cpp 82 2008-05-01 16:48:45Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Decod_unit/Decod_queue/include/Parameters.h"
#include "Behavioural/include/XML.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace decod_unit {
namespace decod_queue {


#undef  FUNCTION
#define FUNCTION "Decod_queue::print"
  std::string Parameters::print (uint32_t depth)
  {
    log_begin(Decod_queue,FUNCTION);

    XML xml ("decod_queue");

    xml.balise_open("decod_queue");
    xml.singleton_begin("nb_context          "); xml.attribut("value",toString(_nb_context       )); xml.singleton_end();
    xml.singleton_begin("nb_inst_decod       "); xml.attribut("value",toString(_nb_inst_decod    )); xml.singleton_end();
    xml.singleton_begin("size_queue          "); xml.attribut("value",toString(_size_queue       )); xml.singleton_end();
    xml.singleton_begin("size_general_data   "); xml.attribut("value",toString(_size_general_data)); xml.singleton_end();
    for (uint32_t i=0;i<_nb_context; i++)
      {
        xml. balise_open_begin("component");
        xml.  attribut("type","context");
        xml.  attribut("id"  ,toString(i));
        xml. balise_open_end();
        xml.  singleton_begin("nb_branch_speculated"); xml.attribut("value",toString(_nb_branch_speculated [i])); xml.singleton_end();
        xml. balise_close();
      }
    xml.balise_close();

    log_end(Decod_queue,FUNCTION);
    
    return xml.get_body(depth);
  };

#undef  FUNCTION
#define FUNCTION "Decod_queue::operator<<"
  std::ostream& operator<< (std::ostream& output_stream ,
			    morpheo::behavioural::core::multi_front_end::front_end::decod_unit::decod_queue::Parameters & x)
  {
    log_begin(Decod_queue,FUNCTION);

    output_stream << x.print(0);
    
    log_end(Decod_queue,FUNCTION);

    return output_stream;
  };

}; // end namespace decod_queue
}; // end namespace decod_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
