/*
 * $Id: main.cpp 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Rename_unit/Rename_unit_Glue/SelfTest/include/test.h"

#define NB_PARAMS 5

void usage (int argc, char * argv[])
{
  err (_("<Usage> %s name_instance list_params.\n"),argv[0]);
  err (_("list_params is :\n"));
  err (_(" * nb_front_end                  (uint32_t)\n"));
  err (_(" * nb_context     [nb_front_end] (uint32_t)\n"));
  err (_(" * nb_inst_insert                (uint32_t)\n"));
  err (_(" * nb_inst_retire                (uint32_t)\n"));
  err (_(" * size_general_data             (uint32_t)\n"));
  err (_(" * size_special_register         (uint32_t)\n"));

  exit (1);
}

#ifndef SYSTEMC
int main    (int argc, char * argv[])
#else
int sc_main (int argc, char * argv[])
#endif
{
  if (argc <= static_cast<int>(2+NB_PARAMS))
    usage (argc, argv);

  uint32_t x = 1;

  string name = argv[x++];

  uint32_t    _nb_front_end   = fromString<uint32_t>(argv[x++]);

  if (argc != static_cast<int>(2+NB_PARAMS+_nb_front_end))
    usage (argc, argv);

  uint32_t  * _nb_context     = new uint32_t [_nb_front_end];
  for (uint32_t i=0; i<_nb_front_end; i++)
    _nb_context [i] = fromString<uint32_t>(argv[x++]);

  
  uint32_t    _nb_inst_insert        = fromString<uint32_t>(argv[x++]);
  uint32_t    _nb_inst_retire        = fromString<uint32_t>(argv[x++]);
  uint32_t    _size_general_data     = fromString<uint32_t>(argv[x++]);
  uint32_t    _size_special_register = fromString<uint32_t>(argv[x++]);

  int _return = EXIT_SUCCESS;
  try 
    {
      morpheo::behavioural::core::multi_ooo_engine::ooo_engine::rename_unit::rename_unit_glue::Parameters * param = new morpheo::behavioural::core::multi_ooo_engine::ooo_engine::rename_unit::rename_unit_glue::Parameters
	(
	 _nb_front_end  ,
	 _nb_context    ,
	 _nb_inst_insert,
	 _nb_inst_retire,
	 _size_general_data,
	 _size_special_register,
         true //is_toplevel
         );
      
      msg(_("%s"),param->print(0).c_str());
      
      test (name,param);
    }
  catch (morpheo::ErrorMorpheo & error)
    {
      msg (_("<%s> :\n%s"),name.c_str(), error.what ());
      _return = EXIT_FAILURE;
    }
  
  try 
    {
      if (_return == EXIT_SUCCESS)
	TEST_OK("Rename_unit_Glue : no error");
      else
	TEST_KO("Rename_unit_Glue : a lot of error");
    }
  catch (morpheo::ErrorMorpheo & error)
    {
//       msg (_("<%s> :\n%s"),name.c_str(), error.what ());
      _return = EXIT_FAILURE;
    }

  delete [] _nb_context;

  return (_return);
}
