/*
 * $Id: Counter.cpp 88 2008-12-10 18:31:39Z rosiere $
 *
 * [Description ]
 * 
 */

#include "Behavioural/Generic/Counter/include/Counter.h"

namespace morpheo                    {
namespace behavioural {
namespace generic {
namespace counter {


  Counter::Counter 
  (
#ifdef SYSTEMC
  sc_module_name name,
#else
  std::string name,
#endif
#ifdef STATISTICS
  morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
  morpheo::behavioural::generic::counter::Parameters param,
   Tusage_t usage):
    _name  (name),
    _param (param),
    _usage (usage)
  {
    log_printf(FUNC,Counter,"Counter","Begin");

#if DEBUG_Counter == true
    log_printf(INFO,Counter,FUNCTION,_("<%s> Parameters"),_name.c_str());

    std::cout << param << std::endl;
#endif    

    log_printf(INFO,Core,FUNCTION,_("<%s> Allocation"),_name.c_str());
    allocation ();

#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      {	
	log_printf(INFO,Core,FUNCTION,_("<%s> Allocation of statistics"),_name.c_str());

        // Allocation of statistics
        statistics_declaration(param_statistics);
      }
#endif

#ifdef VHDL
    if (usage_is_set(_usage,USE_VHDL))
      {
	// generate the vhdl
	log_printf(INFO,Core,FUNCTION,_("<%s> Generate the vhdl"),_name.c_str());
	
        vhdl();
      }
#endif

#ifdef SYSTEMC

    if (usage_is_set(_usage,USE_SYSTEMC))
      {
#if defined(STATISTICS) or defined(VHDL_TESTBENCH)
	log_printf(INFO,Core,FUNCTION,_("<%s> Method - transition"),_name.c_str());

        SC_METHOD (transition);
        dont_initialize ();
        sensitive << (*(in_CLOCK)).pos();
#endif

	log_printf(INFO,Core,FUNCTION,_("<%s> Method - genMealy"),_name.c_str());
        SC_METHOD (genMealy);
        dont_initialize ();
        for (uint32_t i=0; i<_param._nb_port; i++)
          sensitive << *(in_COUNTER_DATA   [i])
                    << *(in_COUNTER_ADDSUB [i]);
        
#ifdef SYSTEMCASS_SPECIFIC
        // List dependency information
        for (uint32_t i=0; i<_param._nb_port; i++)
          {
            (*(out_COUNTER_DATA [i])) (*(in_COUNTER_DATA   [i]));
            (*(out_COUNTER_DATA [i])) (*(in_COUNTER_ADDSUB [i]));
          }
#endif    
      }

#endif
    log_printf(FUNC,Counter,"Counter","End");
  };
  
  Counter::~Counter (void)
  {
    log_printf(FUNC,Counter,"~Counter","Begin");

#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      {
        delete _stat;
      }
#endif

    log_printf(INFO,Core,FUNCTION,_("<%s> Deallocation"),_name.c_str());
    deallocation ();

    log_printf(FUNC,Counter,"~Counter","End");
  };

}; // end namespace counter
}; // end namespace generic

}; // end namespace behavioural
}; // end namespace morpheo              
