/*
 * $Id: Parameters.cpp 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Generic/Victim/include/Parameters.h"

namespace morpheo {
namespace behavioural {
namespace generic {
namespace victim {


#undef  FUNCTION
#define FUNCTION "Victim::Parameters"
  Parameters::Parameters (Tvictim_t victim_scheme    ,
			  uint32_t  nb_entity        ,
			  uint32_t  nb_entry         ,
			  uint32_t  nb_access        ,
			  bool      table_global     )
  {
    log_printf(FUNC,Victim,FUNCTION,"Begin");
    
    _victim_scheme     = victim_scheme;
    _nb_entity         = nb_entity    ;
    _nb_entry          = nb_entry     ;
    _nb_access         = nb_access    ;
    _table_global      = table_global ;
    
    _size_table        = (table_global==true)?1:_nb_entry;
    _size_entity       = log2(nb_entity);
    _size_address      = log2(nb_entry);
    
    _have_port_address = _size_address>0;

    test();

    switch (victim_scheme)
      {
//    case VICTIM_RANDOM      : _param_victim_random      = new morpheo::behavioural::generic::victim::victim_random     ::Parameters (); break;
//    case VICTIM_ROUND_ROBIN : _param_victim_round_robin = new morpheo::behavioural::generic::victim::victim_round_robin::Parameters (); break;
//    case VICTIM_NLU         : _param_victim_nlu         = new morpheo::behavioural::generic::victim::victim_nlu        ::Parameters (); break;
      case VICTIM_PSEUDO_LRU  : _param_victim_pseudo_lru  = new morpheo::behavioural::generic::victim::victim_pseudo_lru ::Parameters (nb_entity, nb_access, nb_entry, table_global); break;
//    case VICTIM_LRU         : _param_victim_lru         = new morpheo::behavioural::generic::victim::victim_lru        ::Parameters (); break;
//    case VICTIM_FIFO        : _param_victim_fifo        = new morpheo::behavioural::generic::victim::victim_fifo       ::Parameters (); break;
      default : break;
      }

    log_printf(FUNC,Victim,FUNCTION,"End");
  };
  
// #undef  FUNCTION
// #define FUNCTION "Victim::Parameters (copy)"
//   Parameters::Parameters (Parameters & param)
//   {
//     log_printf(FUNC,Victim,FUNCTION,"Begin");
//     test();
//     log_printf(FUNC,Victim,FUNCTION,"End");
//   };

#undef  FUNCTION
#define FUNCTION "Victim::~Parameters"
  Parameters::~Parameters () 
  {
    log_printf(FUNC,Victim,FUNCTION,"Begin");

    switch (_victim_scheme)
      {
//    case VICTIM_RANDOM      : delete _param_victim_random     ; break;
//    case VICTIM_ROUND_ROBIN : delete _param_victim_round_robin; break;
//    case VICTIM_NLU         : delete _param_victim_nlu        ; break;
      case VICTIM_PSEUDO_LRU  : delete _param_victim_pseudo_lru ; break;
//    case VICTIM_LRU         : delete _param_victim_lru        ; break;
//    case VICTIM_FIFO        : delete _param_victim_fifo       ; break;
      default : break;
      }

    log_printf(FUNC,Victim,FUNCTION,"End");
  };

#undef  FUNCTION
#define FUNCTION "Victim::copy"
  void morpheo::behavioural::generic::victim::Parameters::copy (void) 
  {
    log_printf(FUNC,Victim,FUNCTION,"Begin");

    switch (_victim_scheme)
      {
//    case VICTIM_RANDOM      : COPY(_param_victim_random     ); break;
//    case VICTIM_ROUND_ROBIN : COPY(_param_victim_round_robin); break;
//    case VICTIM_NLU         : COPY(_param_victim_nlu        ); break;
      case VICTIM_PSEUDO_LRU  : COPY(_param_victim_pseudo_lru ); break;
//    case VICTIM_LRU         : COPY(_param_victim_lru        ); break;
//    case VICTIM_FIFO        : COPY(_param_victim_fifo       ); break;
      default : break;
      }

    log_printf(FUNC,Victim,FUNCTION,"End");
  };

}; // end namespace victim
}; // end namespace generic

}; // end namespace behavioural
}; // end namespace morpheo              
