/*
 * Test_020
 *
 * end_ko : infinite_loop
 * end_ok : Write in R1 the stop address and stop an data
 *          The store in the destination of an jump
 * start  : Test l.fl1
 */
	
	.file	"crt0.s"
	/*
	.section .vector
	*/
	.section .text
	.align	4	

/* ---[ 0x0  : Print a error ]------------------------------------------- */

	.org 0x0
_end_ko        :        
_infinite_loop :        
        l.j	_infinite_loop
        l.nop

_end_ok :
	l.movhi r1,     hi(_tty)
	l.ori   r1, r1, lo(_tty)
        l.sw    4(r1), r1 /* stop address */


/* ---[ 0x100: RESET exception ]----------------------------------------- */
        .org 0x100
	.global _start
_start:

        /**********/
        /* Test 1 */
        /**********/
	l.movhi r1,     hi(0xffffffff) /* RA */
	l.ori   r1, r1, lo(0xffffffff)
        
        l.fl1   r2, r1

        /* Test result */
        l.sfeqi r2, 32
        l.bnf   _end_ko
        l.nop
        
        /**********/
        /* Test 2 */
        /**********/
	l.movhi r1,     hi(0x7fffffff) /* RA */
	l.ori   r1, r1, lo(0x7fffffff)
        
        l.fl1   r2, r1

        /* Test result */
        l.sfeqi r2, 31
        l.bnf   _end_ko
        l.nop

        /**********/
        /* Test 3 */
        /**********/
	l.movhi r1,     hi(0x3fffffff) /* RA */
	l.ori   r1, r1, lo(0x3fffffff)
        
        l.fl1   r2, r1

        /* Test result */
        l.sfeqi r2, 30
        l.bnf   _end_ko
        l.nop
        
        /**********/
        /* Test 4 */
        /**********/
	l.movhi r1,     hi(0x1fffffff) /* RA */
	l.ori   r1, r1, lo(0x1fffffff)
        
        l.fl1   r2, r1

        /* Test result */
        l.sfeqi r2, 29
        l.bnf   _end_ko
        l.nop
        
        /**********/
        /* Test 5 */
        /**********/
	l.movhi r1,     hi(0x0fffffff) /* RA */
	l.ori   r1, r1, lo(0x0fffffff)
        
        l.fl1   r2, r1

        /* Test result */
        l.sfeqi r2, 28
        l.bnf   _end_ko
        l.nop

        /**********/
        /* Test 6 */
        /**********/
	l.movhi r1,     hi(0x07ffffff) /* RA */
	l.ori   r1, r1, lo(0x07ffffff)
        
        l.fl1   r2, r1

        /* Test result */
        l.sfeqi r2, 27
        l.bnf   _end_ko
        l.nop
        
        /**********/
        /* Test 7 */
        /**********/
	l.movhi r1,     hi(0x03ffffff) /* RA */
	l.ori   r1, r1, lo(0x03ffffff)
        
        l.fl1   r2, r1

        /* Test result */
        l.sfeqi r2, 26
        l.bnf   _end_ko
        l.nop

        /**********/
        /* Test 8 */
        /**********/
	l.movhi r1,     hi(0x01ffffff) /* RA */
	l.ori   r1, r1, lo(0x01ffffff)
        
        l.fl1   r2, r1

        /* Test result */
        l.sfeqi r2, 25
        l.bnf   _end_ko
        l.nop
        
        /**********/
        /* Test 9 */
        /**********/
	l.movhi r1,     hi(0x00ffffff) /* RA */
	l.ori   r1, r1, lo(0x00ffffff)
        
        l.fl1   r2, r1

        /* Test result */
        l.sfeqi r2, 24
        l.bnf   _end_ko
        l.nop
        
        /**********/
        /* Test 10*/
        /**********/
	l.movhi r1,     hi(0x007fffff) /* RA */
	l.ori   r1, r1, lo(0x007fffff)
        
        l.fl1   r2, r1

        /* Test result */
        l.sfeqi r2, 23
        l.bnf   _end_ko
        l.nop
        
        /**********/
        /* Test 11*/
        /**********/
	l.movhi r1,     hi(0x003fffff) /* RA */
	l.ori   r1, r1, lo(0x003fffff)
        
        l.fl1   r2, r1

        /* Test result */
        l.sfeqi r2, 22
        l.bnf   _end_ko
        l.nop
        
        /**********/
        /* Test 12*/
        /**********/
	l.movhi r1,     hi(0x001fffff) /* RA */
	l.ori   r1, r1, lo(0x001fffff)
        
        l.fl1   r2, r1

        /* Test result */
        l.sfeqi r2, 21
        l.bnf   _end_ko
        l.nop
        
        /**********/
        /* Test 13*/
        /**********/
	l.movhi r1,     hi(0x000fffff) /* RA */
	l.ori   r1, r1, lo(0x000fffff)
        
        l.fl1   r2, r1

        /* Test result */
        l.sfeqi r2, 20
        l.bnf   _end_ko
        l.nop
        
        /**********/
        /* Test 14*/
        /**********/
	l.movhi r1,     hi(0x0007ffff) /* RA */
	l.ori   r1, r1, lo(0x0007ffff)
        
        l.fl1   r2, r1

        /* Test result */
        l.sfeqi r2, 19
        l.bnf   _end_ko
        l.nop
        
        /**********/
        /* Test 15*/
        /**********/
	l.movhi r1,     hi(0x0003ffff) /* RA */
	l.ori   r1, r1, lo(0x0003ffff)
        
        l.fl1   r2, r1

        /* Test result */
        l.sfeqi r2, 18
        l.bnf   _end_ko
        l.nop
        
        /**********/
        /* Test 16*/
        /**********/
	l.movhi r1,     hi(0x0001ffff) /* RA */
	l.ori   r1, r1, lo(0x0001ffff)
        
        l.fl1   r2, r1

        /* Test result */
        l.sfeqi r2, 17
        l.bnf   _end_ko
        l.nop
        
        /**********/
        /* Test 17*/
        /**********/
	l.movhi r1,     hi(0x0000ffff) /* RA */
	l.ori   r1, r1, lo(0x0000ffff)
        
        l.fl1   r2, r1

        /* Test result */
        l.sfeqi r2, 16
        l.bnf   _end_ko
        l.nop
        
        /**********/
        /* Test 18*/
        /**********/
	l.movhi r1,     hi(0x00007fff) /* RA */
	l.ori   r1, r1, lo(0x00007fff)
        
        l.fl1   r2, r1

        /* Test result */
        l.sfeqi r2, 15
        l.bnf   _end_ko
        l.nop
        
        /**********/
        /* Test 19*/
        /**********/
	l.movhi r1,     hi(0x00003fff) /* RA */
	l.ori   r1, r1, lo(0x00003fff)
        
        l.fl1   r2, r1

        /* Test result */
        l.sfeqi r2, 14
        l.bnf   _end_ko
        l.nop
        
        /**********/
        /* Test 20*/
        /**********/
	l.movhi r1,     hi(0x00001fff) /* RA */
	l.ori   r1, r1, lo(0x00001fff)
        
        l.fl1   r2, r1

        /* Test result */
        l.sfeqi r2, 13
        l.bnf   _end_ko
        l.nop
        
        /**********/
        /* Test 21*/
        /**********/
	l.movhi r1,     hi(0x00000fff) /* RA */
	l.ori   r1, r1, lo(0x00000fff)
        
        l.fl1   r2, r1

        /* Test result */
        l.sfeqi r2, 12
        l.bnf   _end_ko
        l.nop
        
        /**********/
        /* Test 22*/
        /**********/
	l.movhi r1,     hi(0x000007ff) /* RA */
	l.ori   r1, r1, lo(0x000007ff)
        
        l.fl1   r2, r1

        /* Test result */
        l.sfeqi r2, 11
        l.bnf   _end_ko
        l.nop
        
        /**********/
        /* Test 23*/
        /**********/
	l.movhi r1,     hi(0x000003ff) /* RA */
	l.ori   r1, r1, lo(0x000003ff)
        
        l.fl1   r2, r1

        /* Test result */
        l.sfeqi r2, 10
        l.bnf   _end_ko
        l.nop
        
        /**********/
        /* Test 24*/
        /**********/
	l.movhi r1,     hi(0x000001ff) /* RA */
	l.ori   r1, r1, lo(0x000001ff)
        
        l.fl1   r2, r1

        /* Test result */
        l.sfeqi r2, 9 
        l.bnf   _end_ko
        l.nop
        
        /**********/
        /* Test 25*/
        /**********/
	l.movhi r1,     hi(0x000000ff) /* RA */
	l.ori   r1, r1, lo(0x000000ff)
        
        l.fl1   r2, r1

        /* Test result */
        l.sfeqi r2, 8
        l.bnf   _end_ko
        l.nop
        
        /**********/
        /* Test 26*/
        /**********/
	l.movhi r1,     hi(0x0000007f) /* RA */
	l.ori   r1, r1, lo(0x0000007f)
        
        l.fl1   r2, r1

        /* Test result */
        l.sfeqi r2, 7
        l.bnf   _end_ko
        l.nop
        
        /**********/
        /* Test 27*/
        /**********/
	l.movhi r1,     hi(0x0000003f) /* RA */
	l.ori   r1, r1, lo(0x0000003f)
        
        l.fl1   r2, r1

        /* Test result */
        l.sfeqi r2, 6
        l.bnf   _end_ko
        l.nop
        
        /**********/
        /* Test 28*/
        /**********/
	l.movhi r1,     hi(0x0000001f) /* RA */
	l.ori   r1, r1, lo(0x0000001f)
        
        l.fl1   r2, r1

        /* Test result */
        l.sfeqi r2, 5
        l.bnf   _end_ko
        l.nop
        
        /**********/
        /* Test 29*/
        /**********/
	l.movhi r1,     hi(0x0000000f) /* RA */
	l.ori   r1, r1, lo(0x0000000f)
        
        l.fl1   r2, r1

        /* Test result */
        l.sfeqi r2, 4
        l.bnf   _end_ko
        l.nop
        
        /**********/
        /* Test 30*/
        /**********/
	l.movhi r1,     hi(0x00000007) /* RA */
	l.ori   r1, r1, lo(0x00000007)
        
        l.fl1   r2, r1

        /* Test result */
        l.sfeqi r2, 3
        l.bnf   _end_ko
        l.nop
        
        /**********/
        /* Test 31*/
        /**********/
	l.movhi r1,     hi(0x00000003) /* RA */
	l.ori   r1, r1, lo(0x00000003)
        
        l.fl1   r2, r1

        /* Test result */
        l.sfeqi r2, 2
        l.bnf   _end_ko
        l.nop
        
        /**********/
        /* Test 32*/
        /**********/
	l.movhi r1,     hi(0x00000001) /* RA */
	l.ori   r1, r1, lo(0x00000001)
        
        l.fl1   r2, r1

        /* Test result */
        l.sfeqi r2, 1
        l.bnf   _end_ko
        l.nop
        
        /**********/
        /* Test 33*/
        /**********/
	l.movhi r1,     hi(0x00000000) /* RA */
	l.ori   r1, r1, lo(0x00000000)
        
        l.fl1   r2, r1

        /* Test result */
        l.sfeqi r2, 0
        l.bnf   _end_ko
        l.nop
        
        /**********/
        /* End */
        /**********/

        l.j     _end_ok
        l.nop
