#ifndef morpheo_behavioural_core_multi_front_end_front_end_front_end_glue_Parameters_h
#define morpheo_behavioural_core_multi_front_end_front_end_front_end_glue_Parameters_h

/*
 * $Id: Parameters.h 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/include/Parameters.h"
#include "Common/include/Debug.h"
#include <vector>

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace front_end_glue {


  class Parameters : public morpheo::behavioural::Parameters
  {
    //-----[ fields ]------------------------------------------------------------
  public : uint32_t                _nb_context                           ;
  public : uint32_t                _nb_decod_unit                        ;
  public : uint32_t              * _nb_inst_decod                        ;//[nb_decod_unit]
  public : uint32_t                _nb_inst_branch_complete              ;
  public : uint32_t              * _link_context_to_decod_unit           ;//[nb_context]
  public : std::vector<uint32_t> * _translate_context_id_from_decod_unit ;//[nb_decod_unit]{decod_unit_nb_context} -> nb_context
//public : uint32_t                _size_address                         ;
//public : uint32_t              * _size_depth                           ;//[nb_context]
  public : uint32_t              * _nb_branch_speculated                 ;//[nb_context]

  public : uint32_t              * _decod_unit_nb_context                ;//[nb_decod_unit]
//public : uint32_t              * _size_decod_unit_context_id           ;//[nb_decod_unit]
//public : uint32_t                _size_context_id                      ;
//public : uint32_t                _max_size_depth                       ;

//public : bool                  * _have_port_decod_unit_context_id      ;//[nb_decod_unit]
//public : bool                    _have_port_context_id                 ;
//public : bool                  * _have_port_depth                      ;//[nb_context]
//public : bool                    _have_port_max_depth                  ;

    //-----[ methods ]-----------------------------------------------------------
  public : Parameters  (uint32_t                nb_context                           ,
                        uint32_t                nb_decod_unit                        ,
                        uint32_t              * nb_inst_decod                        ,
                        uint32_t                nb_inst_branch_complete              ,
                        uint32_t              * link_context_to_decod_unit           ,
                        std::vector<uint32_t> * translate_context_id_from_decod_unit ,
                        uint32_t                size_address                         ,
                        uint32_t              * size_depth                           ,
                        uint32_t              * nb_branch_speculated                 ,
                        uint32_t                is_toplevel=false);
//   public : Parameters  (Parameters & param) ;
  public : ~Parameters () ;

  public :        void            copy       (void);

  public :        Parameters_test msg_error  (void);

  public :        std::string     print      (uint32_t depth);
  public : friend std::ostream&   operator<< (std::ostream& output_stream,
					    morpheo::behavioural::core::multi_front_end::front_end::front_end_glue::Parameters & x);
  };

}; // end namespace front_end_glue
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              

#endif
