#ifndef morpheo_behavioural_core_multi_front_end_front_end_prediction_unit_direction_meta_predictor_meta_predictor_glue_Parameters_h
#define morpheo_behavioural_core_multi_front_end_front_end_prediction_unit_direction_meta_predictor_meta_predictor_glue_Parameters_h

/*
 * $Id: Parameters.h 81 2008-04-15 18:40:01Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Common/include/Debug.h"
#include "Behavioural/include/Parameters.h"
#include <math.h>

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace prediction_unit {
namespace direction {

namespace meta_predictor {
namespace meta_predictor_glue {


  class Parameters : public morpheo::behavioural::Parameters
  {
    //-----[ fields ]------------------------------------------------------------
  public : const bool     _have_meta_predictor               ;

  public : const bool     _predictor_0_have_bht              ;
  public : const uint32_t _predictor_0_bht_size_shifter      ;
  public : const bool     _predictor_0_have_pht              ;
  public : const uint32_t _predictor_0_pht_size_counter      ;

  public : const bool     _predictor_1_have_bht              ;
  public : const uint32_t _predictor_1_bht_size_shifter      ;
  public : const bool     _predictor_1_have_pht              ;
  public : const uint32_t _predictor_1_pht_size_counter      ;

  public : const bool     _predictor_2_have_bht              ;
  public : const uint32_t _predictor_2_bht_size_shifter      ;
  public : const bool     _predictor_2_have_pht              ;
  public : const uint32_t _predictor_2_pht_size_counter      ;

  public : const uint32_t _nb_prediction                     ;
  public : const uint32_t _nb_branch_complete                ;

  public : const uint32_t _size_history                      ;

  public : const uint32_t _shift_0;
  public : const uint32_t _shift_1;
  public : const uint32_t _shift_2;
  public : const uint32_t _shift_3;
  public : const uint32_t _shift_4;
  public : const uint32_t _shift_5;
  public : const uint32_t _shift_6;

    //-----[ methods ]-----------------------------------------------------------
  public : Parameters  (bool     have_meta_predictor               ,
			bool     predictor_0_have_bht              ,
			uint32_t predictor_0_bht_size_shifter      ,
			bool     predictor_0_have_pht              ,
			uint32_t predictor_0_pht_size_counter      ,
			bool     predictor_1_have_bht              ,
			uint32_t predictor_1_bht_size_shifter      ,
			bool     predictor_1_have_pht              ,
			uint32_t predictor_1_pht_size_counter      ,
			bool     predictor_2_have_bht              ,
			uint32_t predictor_2_bht_size_shifter      ,
			bool     predictor_2_have_pht              ,
			uint32_t predictor_2_pht_size_counter      ,
			uint32_t nb_prediction                     ,
			uint32_t nb_branch_complete                );
  public : Parameters  (Parameters & param) ;
  public : ~Parameters () ;

  public : string msg_error (void);

  public :        string   print      (uint32_t depth);
  public : friend ostream& operator<< (ostream& output_stream,
				       morpheo::behavioural::core::multi_front_end::front_end::prediction_unit::direction::meta_predictor::meta_predictor_glue::Parameters & x);
  };

}; // end namespace meta_predictor_glue
}; // end namespace meta_predictor

}; // end namespace core
}; // end namespace multi_front_end
}; // end namespace front_end
}; // end namespace prediction_unit
}; // end namespace direction


}; // end namespace behavioural
}; // end namespace morpheo              

#endif
