#ifndef morpheo_behavioural_core_multi_execute_loop_execute_loop_execute_loop_glue_Execute_loop_Glue_h
#define morpheo_behavioural_core_multi_execute_loop_execute_loop_execute_loop_glue_Execute_loop_Glue_h

/*
 * $Id: Execute_loop_Glue.h 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#ifdef SYSTEMC
#include "systemc.h"
#endif


#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Execute_loop_Glue/include/Parameters.h"
#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Execute_loop_Glue/include/Types.h"
#ifdef STATISTICS
#include "Behavioural/include/Stat.h"
#endif
#include "Behavioural/include/Component.h"
#ifdef VHDL
#include "Behavioural/include/Vhdl.h"
#endif
#include "Behavioural/include/Usage.h"

#include "Common/include/ToString.h"
#include "Common/include/Debug.h"

#include <iostream>

namespace morpheo {
namespace behavioural {

namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace execute_loop_glue {


  class Execute_loop_Glue 
#if SYSTEMC
    : public sc_module
#endif
  {
    // -----[ fields ]----------------------------------------------------
    // Parameters
  protected : const std::string  _name;
  protected : const Parameters * _param;
  private   : const Tusage_t     _usage;

#ifdef STATISTICS
  public    : Stat                           * _stat;
#endif

  public    : Component                      * _component;
  private   : Interfaces                     * _interfaces;

#ifdef SYSTEMC
    // ~~~~~[ Interface ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    // ~~~~~[ Interface : "" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_CLOCK                      *  in_CLOCK        ;
  public    : SC_IN (Tcontrol_t)            *  in_NRESET       ;

    // -----[ Interface "gpr_write_write_unit" ]--------------------------
  public    : SC_IN (Tcontrol_t        )   **  in_GPR_WRITE_WRITE_UNIT_VAL               ;
  public    : SC_OUT(Tcontrol_t        )   ** out_GPR_WRITE_WRITE_UNIT_ACK               ;
  public    : SC_IN (Tcontext_t        )   **  in_GPR_WRITE_WRITE_UNIT_OOO_ENGINE_ID     ;
  public    : SC_IN (Tgeneral_address_t)   **  in_GPR_WRITE_WRITE_UNIT_NUM_REG           ;
  public    : SC_IN (Tgeneral_data_t   )   **  in_GPR_WRITE_WRITE_UNIT_DATA              ;

    // -----[ Interface "gpr_write_register_file" ]-----------------------
  public    : SC_OUT(Tcontrol_t        )   ** out_GPR_WRITE_REGISTER_FILE_VAL            ;
  public    : SC_IN (Tcontrol_t        )   **  in_GPR_WRITE_REGISTER_FILE_ACK            ;
  public    : SC_OUT(Tcontext_t        )   ** out_GPR_WRITE_REGISTER_FILE_OOO_ENGINE_ID  ;
  public    : SC_OUT(Tgeneral_address_t)   ** out_GPR_WRITE_REGISTER_FILE_NUM_REG        ;
  public    : SC_OUT(Tgeneral_data_t   )   ** out_GPR_WRITE_REGISTER_FILE_DATA           ;

    // -----[ Interface "gpr_write_read_unit" ]---------------------------
  public    : SC_OUT(Tcontrol_t        )   ** out_GPR_WRITE_READ_UNIT_VAL                ;
  public    : SC_OUT(Tcontext_t        )   ** out_GPR_WRITE_READ_UNIT_OOO_ENGINE_ID      ;
  public    : SC_OUT(Tgeneral_address_t)   ** out_GPR_WRITE_READ_UNIT_NUM_REG            ;
  public    : SC_OUT(Tgeneral_data_t   )   ** out_GPR_WRITE_READ_UNIT_DATA               ;

    // -----[ Interface "spr_write_write_unit" ]--------------------------
  public    : SC_IN (Tcontrol_t        )   **  in_SPR_WRITE_WRITE_UNIT_VAL               ;
  public    : SC_OUT(Tcontrol_t        )   ** out_SPR_WRITE_WRITE_UNIT_ACK               ;
  public    : SC_IN (Tcontext_t        )   **  in_SPR_WRITE_WRITE_UNIT_OOO_ENGINE_ID     ;
  public    : SC_IN (Tspecial_address_t)   **  in_SPR_WRITE_WRITE_UNIT_NUM_REG           ;
  public    : SC_IN (Tspecial_data_t   )   **  in_SPR_WRITE_WRITE_UNIT_DATA              ;

    // -----[ Interface "spr_write_register_file" ]-----------------------
  public    : SC_OUT(Tcontrol_t        )   ** out_SPR_WRITE_REGISTER_FILE_VAL            ;
  public    : SC_IN (Tcontrol_t        )   **  in_SPR_WRITE_REGISTER_FILE_ACK            ;
  public    : SC_OUT(Tcontext_t        )   ** out_SPR_WRITE_REGISTER_FILE_OOO_ENGINE_ID  ;
  public    : SC_OUT(Tspecial_address_t)   ** out_SPR_WRITE_REGISTER_FILE_NUM_REG        ;
  public    : SC_OUT(Tspecial_data_t   )   ** out_SPR_WRITE_REGISTER_FILE_DATA           ;

    // -----[ Interface "spr_write_read_unit" ]---------------------------
  public    : SC_OUT(Tcontrol_t        )   ** out_SPR_WRITE_READ_UNIT_VAL                ;
  public    : SC_OUT(Tcontext_t        )   ** out_SPR_WRITE_READ_UNIT_OOO_ENGINE_ID      ;
  public    : SC_OUT(Tspecial_address_t)   ** out_SPR_WRITE_READ_UNIT_NUM_REG            ;
  public    : SC_OUT(Tspecial_data_t   )   ** out_SPR_WRITE_READ_UNIT_DATA               ;
    
    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    // ~~~~~[ Register ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    // ~~~~~[ Internal ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#endif

    // -----[ Methods ]---------------------------------------------------

#ifdef SYSTEMC
    SC_HAS_PROCESS (Execute_loop_Glue);
#endif
  public  :          Execute_loop_Glue              
  (
#ifdef SYSTEMC
   sc_module_name                                name,
#else					       
   std::string                                   name,
#endif					       
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
   Parameters                                  * param,
   morpheo::behavioural::Tusage_t                usage
   );
  public  :          ~Execute_loop_Glue             (void);
					       
  private : void        allocation                (
#ifdef STATISTICS
						   morpheo::behavioural::Parameters_Statistics * param_statistics
#else
						   void
#endif
						   );
  private : void        deallocation              (void);
					       
#ifdef SYSTEMC				       
  public  : void        transition                (void);
//public  : void        genMoore                  (void);
  public  : void        genMealy_gpr_write        (void);
  public  : void        genMealy_spr_write        (void);
#endif					       

#if VHDL				       
  public  : void        vhdl                      (void);
  private : void        vhdl_declaration          (Vhdl * & vhdl);
  private : void        vhdl_body                 (Vhdl * & vhdl);
#endif					       

#ifdef STATISTICS
  public  : void        statistics_allocation     (morpheo::behavioural::Parameters_Statistics * param_statistics);
  public  : void        statistics_deallocation   (void);
#endif
#if defined(STATISTICS) or defined(VHDL_TESTBENCH)
  private : void        end_cycle                 (void);
#endif
  };

}; // end namespace execute_loop_glue
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              

#endif
