/*
 * Routine system dependant
 *  - reset
 *  - exception handler
 *  - start / exit
 */

/*		
#define DEFAULT_EXCEPTION_HANDLER     \
	l.addi  r1, r1, -128         ;\
	l.sw    4(r1), r3            ;\ 
	l.sw    8(r1), r4	     ;\
	l.mfspr r3,r0,16             ;\
	l.mfspr r4,r0,32             ;\
	l.j default_exception_handler;\
	l.nop	0                    ;
*/
	
	.file	"crt0.s"
	/*
	.section .vector
	*/
	.section .text
	.align	4	

/* ---[ 0x0  : Print a error ]------------------------------------------- */

	.org 0x0

	l.movhi r3,   0xdead
	l.jal	_quit
	l.ori	r3,r3,0xdead

	/*
	l.nop	-0
	l.nop	-1
	l.nop	-2
	l.nop	-3
	l.nop	-4
	l.nop	-5
	l.nop	-6
	l.nop	-7
	l.nop	-8
	l.nop	-9
	l.nop	-10
	l.nop	-11
	l.nop	-12
	l.nop	-13
	l.nop	-14
	l.nop	-15
	l.nop	-16
	l.nop	-17
	l.nop	-18
	l.nop	-19
	l.nop	-20
	l.nop	-21
	l.nop	-22
	l.nop	-23
	l.nop	-24
	l.nop	-25
	l.nop	-26
	l.nop	-27
	l.nop	-28
	l.nop	-29
	l.nop	-30
	l.nop	-31
	l.nop	-32
	l.nop	-33
	l.nop	-34
	l.nop	-35
	l.nop	-36
	l.nop	-37
	l.nop	-38
	l.nop	-39
	l.nop	-40
	l.nop	-41
	l.nop	-42
	l.nop	-43
	l.nop	-44
	l.nop	-45
	l.nop	-46
	l.nop	-47
	l.nop	-48
	l.nop	-49
	l.nop	-50
	l.nop	-51
	l.nop	-52
	l.nop	-53
	l.nop	-54
	l.nop	-55
	l.nop	-56
	l.nop	-57
	l.nop	-58
	l.nop	-59
	l.nop	-60
	l.nop	-61
	l.nop	-62
	l.nop	-63
	*/

/* ---[ 0x100: RESET exception ]----------------------------------------- */
        .org 0x100
	.global _exception_reset
_exception_reset:

	l.movhi r2,   hi(_start)
	l.ori   r2,r2,lo(_start)
	l.jr    r2		 /* Go _start */
	l.nop	0

/* ---[ 0x200: BUS exception ]------------------------------------------- */
	.org 0x200
	/*DEFAULT_EXCEPTION_HANDLER*/
	l.addi  r1, r1, -128         
	l.sw    4(r1), r3             
	l.sw    8(r1), r4	     
	l.mfspr r3,r0,16             
	l.mfspr r4,r0,32             
	l.j default_exception_handler
	l.nop	0                    
	

/* ---[ 0x300: Data Page Fault exception ]------------------------------- */
	.org 0x300
	/*DEFAULT_EXCEPTION_HANDLER*/
	l.addi  r1, r1, -128         
	l.sw    4(r1), r3             
	l.sw    8(r1), r4	     
	l.mfspr r3,r0,16             
	l.mfspr r4,r0,32             
	l.j default_exception_handler
	l.nop	0                    

	
/* ---[ 0x400: Insn Page Fault exception ]------------------------------- */
	.org 0x400
	/*DEFAULT_EXCEPTION_HANDLER*/
	l.addi  r1, r1, -128         
	l.sw    4(r1), r3             
	l.sw    8(r1), r4	     
	l.mfspr r3,r0,16             
	l.mfspr r4,r0,32             
	l.j default_exception_handler
	l.nop	0                    


/* ---[ 0x500: Timer exception ]----------------------------------------- */
	.org 0x500
	/*DEFAULT_EXCEPTION_HANDLER*/
	l.addi  r1, r1, -128         
	l.sw    4(r1), r3             
	l.sw    8(r1), r4	     
	l.mfspr r3,r0,16             
	l.mfspr r4,r0,32             
	l.j default_exception_handler
	l.nop	0                    


/* ---[ 0x600: Aligment exception ]-------------------------------------- */
	.org 0x600
	/*DEFAULT_EXCEPTION_HANDLER*/
	l.addi  r1, r1, -128         
	l.sw    4(r1), r3             
	l.sw    8(r1), r4	     
	l.mfspr r3,r0,16             
	l.mfspr r4,r0,32             
	l.j default_exception_handler
	l.nop	0                    

	
/* ---[ 0x700: Illegal insn exception ]---------------------------------- */
	.org 0x700
	/*DEFAULT_EXCEPTION_HANDLER*/
	l.addi  r1, r1, -128         
	l.sw    4(r1), r3             
	l.sw    8(r1), r4	     
	l.mfspr r3,r0,16             
	l.mfspr r4,r0,32             
	l.j default_exception_handler
	l.nop	0                    


/* ---[ 0x800: External interrupt exception ]---------------------------- */
	.org 0x800
	/*DEFAULT_EXCEPTION_HANDLER*/
	l.addi  r1, r1, -128         
	l.sw    4(r1), r3             
	l.sw    8(r1), r4	     
	l.mfspr r3,r0,16             
	l.mfspr r4,r0,32             
	l.j default_exception_handler
	l.nop	0                    


/* ---[ 0x900: DTLB miss exception ]------------------------------------- */
	.org 0x900
	/*DEFAULT_EXCEPTION_HANDLER*/
	l.addi  r1, r1, -128         
	l.sw    4(r1), r3             
	l.sw    8(r1), r4	     
	l.mfspr r3,r0,16             
	l.mfspr r4,r0,32             
	l.j default_exception_handler
	l.nop	0                    

	
/* ---[ 0xa00: ITLB miss exception ]------------------------------------- */
	.org 0xa00
	/*DEFAULT_EXCEPTION_HANDLER*/
	l.addi  r1, r1, -128         
	l.sw    4(r1), r3             
	l.sw    8(r1), r4	     
	l.mfspr r3,r0,16             
	l.mfspr r4,r0,32             
	l.j default_exception_handler
	l.nop	0                    

	
		
/* ---[ 0xb00: Range exception ]----------------------------------------- */
	.org 0xb00
	/*DEFAULT_EXCEPTION_HANDLER*/
	l.addi  r1, r1, -128         
	l.sw    4(r1), r3             
	l.sw    8(r1), r4	     
	l.mfspr r3,r0,16             
	l.mfspr r4,r0,32             
	l.j default_exception_handler
	l.nop	0                    

	

/* ---[ 0xc00: Syscall exception ]--------------------------------------- */
	.org 0xc00
	/*DEFAULT_EXCEPTION_HANDLER*/
	l.addi  r1, r1, -128         
	l.sw    4(r1), r3             
	l.sw    8(r1), r4	     
	l.mfspr r3,r0,16             
	l.mfspr r4,r0,32             
	l.j default_exception_handler
	l.nop	0                    

	

/* ---[ 0xd00: Trap exception ]------------------------------------------ */
	.org 0xd00
	/*DEFAULT_EXCEPTION_HANDLER*/
	l.addi  r1, r1, -128         
	l.sw    4(r1), r3             
	l.sw    8(r1), r4	     
	l.mfspr r3,r0,16             
	l.mfspr r4,r0,32             
	l.j default_exception_handler
	l.nop	0                    

	

/* ---[ 0xe00: Trap exception ]------------------------------------------ */
	.org 0xe00
	/*DEFAULT_EXCEPTION_HANDLER*/
	l.addi  r1, r1, -128         
	l.sw    4(r1), r3             
	l.sw    8(r1), r4	     
	l.mfspr r3,r0,16             
	l.mfspr r4,r0,32             
	l.j default_exception_handler
	l.nop	0                    

	
	
/* ---[ 0xf00: Reserved exceptions ]------------------------------------- */
	.org 0xf00
	/*DEFAULT_EXCEPTION_HANDLER*/
	l.addi  r1, r1, -128         
	l.sw    4(r1), r3             
	l.sw    8(r1), r4	     
	l.mfspr r3,r0,16             
	l.mfspr r4,r0,32             
	l.j default_exception_handler
	l.nop	0                    

	
	.org 0x1000
	/*DEFAULT_EXCEPTION_HANDLER*/
	l.addi  r1, r1, -128         
	l.sw    4(r1), r3             
	l.sw    8(r1), r4	     
	l.mfspr r3,r0,16             
	l.mfspr r4,r0,32             
	l.j default_exception_handler
	l.nop	0                    

	
	.org 0x1100
	/*DEFAULT_EXCEPTION_HANDLER*/
	l.addi  r1, r1, -128         
	l.sw    4(r1), r3             
	l.sw    8(r1), r4	     
	l.mfspr r3,r0,16             
	l.mfspr r4,r0,32             
	l.j default_exception_handler
	l.nop	0                    

	
	.org 0x1200
	/*DEFAULT_EXCEPTION_HANDLER*/
	l.addi  r1, r1, -128         
	l.sw    4(r1), r3             
	l.sw    8(r1), r4	     
	l.mfspr r3,r0,16             
	l.mfspr r4,r0,32             
	l.j default_exception_handler
	l.nop	0                    

	
	.org 0x1300
	/*DEFAULT_EXCEPTION_HANDLER*/
	l.addi  r1, r1, -128         
	l.sw    4(r1), r3             
	l.sw    8(r1), r4	     
	l.mfspr r3,r0,16             
	l.mfspr r4,r0,32             
	l.j default_exception_handler
	l.nop	0                    

	
	.org 0x1400
	/*DEFAULT_EXCEPTION_HANDLER*/
	l.addi  r1, r1, -128         
	l.sw    4(r1), r3             
	l.sw    8(r1), r4	     
	l.mfspr r3,r0,16             
	l.mfspr r4,r0,32             
	l.j default_exception_handler
	l.nop	0                    

	
	.org 0x1500
	/*DEFAULT_EXCEPTION_HANDLER*/
	l.addi  r1, r1, -128         
	l.sw    4(r1), r3             
	l.sw    8(r1), r4	     
	l.mfspr r3,r0,16             
	l.mfspr r4,r0,32             
	l.j default_exception_handler
	l.nop	0                    

	
	.org 0x1600
	/*DEFAULT_EXCEPTION_HANDLER*/
	l.addi  r1, r1, -128         
	l.sw    4(r1), r3             
	l.sw    8(r1), r4	     
	l.mfspr r3,r0,16             
	l.mfspr r4,r0,32             
	l.j default_exception_handler
	l.nop	0                    

	
	.org 0x1700
	/*DEFAULT_EXCEPTION_HANDLER*/
	l.addi  r1, r1, -128         
	l.sw    4(r1), r3             
	l.sw    8(r1), r4	     
	l.mfspr r3,r0,16             
	l.mfspr r4,r0,32             
	l.j default_exception_handler
	l.nop	0                    

	
	.org 0x1800
	/*DEFAULT_EXCEPTION_HANDLER*/
	l.addi  r1, r1, -128         
	l.sw    4(r1), r3             
	l.sw    8(r1), r4	     
	l.mfspr r3,r0,16             
	l.mfspr r4,r0,32             
	l.j default_exception_handler
	l.nop	0                    

	
	.org 0x1900
	/*DEFAULT_EXCEPTION_HANDLER*/
	l.addi  r1, r1, -128         
	l.sw    4(r1), r3             
	l.sw    8(r1), r4	     
	l.mfspr r3,r0,16             
	l.mfspr r4,r0,32             
	l.j default_exception_handler
	l.nop	0                    

	
	.org 0x1a00
	/*DEFAULT_EXCEPTION_HANDLER*/
	l.addi  r1, r1, -128         
	l.sw    4(r1), r3             
	l.sw    8(r1), r4	     
	l.mfspr r3,r0,16             
	l.mfspr r4,r0,32             
	l.j default_exception_handler
	l.nop	0                    

	
	.org 0x1b00
	/*DEFAULT_EXCEPTION_HANDLER*/
	l.addi  r1, r1, -128         
	l.sw    4(r1), r3             
	l.sw    8(r1), r4	     
	l.mfspr r3,r0,16             
	l.mfspr r4,r0,32             
	l.j default_exception_handler
	l.nop	0                    

	
	.org 0x1c00
	/*DEFAULT_EXCEPTION_HANDLER*/
	l.addi  r1, r1, -128         
	l.sw    4(r1), r3             
	l.sw    8(r1), r4	     
	l.mfspr r3,r0,16             
	l.mfspr r4,r0,32             
	l.j default_exception_handler
	l.nop	0                    

	
	.org 0x1d00
	/*DEFAULT_EXCEPTION_HANDLER*/
	l.addi  r1, r1, -128         
	l.sw    4(r1), r3             
	l.sw    8(r1), r4	     
	l.mfspr r3,r0,16             
	l.mfspr r4,r0,32             
	l.j default_exception_handler
	l.nop	0                    

	
	.org 0x1e00
	/*DEFAULT_EXCEPTION_HANDLER*/
	l.addi  r1, r1, -128         
	l.sw    4(r1), r3             
	l.sw    8(r1), r4	     
	l.mfspr r3,r0,16             
	l.mfspr r4,r0,32             
	l.j default_exception_handler
	l.nop	0                    

	
	.org 0x1f00
	/*DEFAULT_EXCEPTION_HANDLER*/
	l.addi  r1, r1, -128         
	l.sw    4(r1), r3             
	l.sw    8(r1), r4	     
	l.mfspr r3,r0,16             
	l.mfspr r4,r0,32             
	l.j default_exception_handler
	l.nop	0                    


/* ========================================================= [ entry ] === */

	.org 0x2000
	.global _start
	
_start:
	/* Initialise stack */

	l.movhi r1,     hi(_stack)
	l.ori   r1, r1, lo(_stack)
	l.addi  r2, r0, -3		  /* 0xFFFF_FFFC */

	l.jal	_get_cpu_id               /* give the id of the cpu */
	l.and   r1, r1, r2

	l.movhi r4,     hi(_stack_alloc)
	l.ori   r4, r4, lo(_stack_alloc)

	l.mul	r4, r11,r4
	l.sub	r1, r1 ,r4                /* each thread have a <<_stack>> with a size <<_stack_alloc>> */
	l.or	r2, r1, r0                /* copy in frame_pointer register */

	/* Clear BSS */
/*
	l.movhi r28,      hi(___bss_start)
	l.ori   r28, r28, lo(___bss_start)
	l.movhi r30,      hi(__end)
	l.ori   r30, r30, lo(__end)
1:
        l.sw    (0)(r28), r0
        l.sfltu r28, r30
        l.bf    1b
        l.addi  r28, r28, 4
*/
	/* Jump to main program entry point (argc = argv = 0) */
	l.and	r3,r0,r0
	l.jal   _main
	l.and	r4,r0,r0
	
	/* If program exits, call exit routine */
/*
	l.addi  r3, r11, 0
	l.jal   __exit
	l.nop	0
*/
/* ====================================== [ default exception handler ] === */

default_exception_handler:
	l.sw    0x00(r1), r2
	l.sw    0x0c(r1), r5
	l.sw    0x10(r1), r6
	l.sw    0x14(r1), r7
	l.sw    0x18(r1), r8
	l.sw    0x1c(r1), r9
	l.sw    0x20(r1), r10
	l.sw    0x24(r1), r11
	l.sw    0x28(r1), r12
	l.sw    0x2c(r1), r13
	l.sw    0x30(r1), r14
	l.sw    0x34(r1), r15
	l.sw    0x38(r1), r16
	l.sw    0x3c(r1), r17
	l.sw    0x40(r1), r18
	l.sw    0x44(r1), r19
	l.sw    0x48(r1), r20
	l.sw    0x4c(r1), r21
	l.sw    0x50(r1), r22
	l.sw    0x54(r1), r23
	l.sw    0x58(r1), r24
	l.sw    0x5c(r1), r25
	l.sw    0x60(r1), r26
	l.sw    0x64(r1), r27
	l.sw    0x68(r1), r28
	l.sw    0x6c(r1), r29
	l.sw    0x70(r1), r30
	l.sw    0x74(r1), r31
	l.sw    0x78(r1), r32
	
	/*
	 * Jump to a handler (write in C by example)
	 */
	
	l.jal   _exception_handler
	l.nop	0
	
	l.lwz   r2 , 0x00(r1)
	l.lwz   r3 , 0x04(r1)
	l.lwz   r4 , 0x08(r1)
	l.lwz   r5 , 0x0c(r1)
	l.lwz   r6 , 0x10(r1)
	l.lwz   r7 , 0x14(r1)
	l.lwz   r8 , 0x18(r1)
	l.lwz   r9 , 0x1c(r1)
	l.lwz   r10, 0x20(r1)
	l.lwz   r11, 0x24(r1)
	l.lwz   r12, 0x28(r1)
	l.lwz   r13, 0x2c(r1)
	l.lwz   r14, 0x30(r1)
	l.lwz   r15, 0x34(r1)
	l.lwz   r16, 0x38(r1)
	l.lwz   r17, 0x3c(r1)
	l.lwz   r18, 0x40(r1)
	l.lwz   r19, 0x44(r1)
	l.lwz   r20, 0x48(r1)
	l.lwz   r21, 0x4c(r1)
	l.lwz   r22, 0x50(r1)
	l.lwz   r23, 0x54(r1)
	l.lwz   r24, 0x58(r1)
	l.lwz   r25, 0x5c(r1)
	l.lwz   r26, 0x60(r1)
	l.lwz   r27, 0x64(r1)
	l.lwz   r28, 0x68(r1)
	l.lwz   r29, 0x6c(r1)
	l.lwz   r30, 0x70(r1)
	l.lwz   r31, 0x74(r1)
	l.lwz   r32, 0x78(r1)

	l.addi  r1, r1, 128

	l.rfe
	l.nop	0
