/*
 * $Id: Parameters_msg_error.cpp 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/include/Types.h"
#include "Behavioural/Core/Multi_Front_end/Front_end/Context_State/include/Parameters.h"
#include <sstream>

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace context_state {


#undef  FUNCTION
#define FUNCTION "Context_State::msg_error"
  Parameters_test Parameters::msg_error(void)
  {
    log_begin(Context_State,FUNCTION);

    Parameters_test test ("Context_State");

    bool _is_link_decod_unit_from_context [_nb_decod_unit];
    for (uint32_t i=0; i<_nb_decod_unit; i++)
      _is_link_decod_unit_from_context [i] = false;
    for (uint32_t i=0; i<_nb_context; i++)
      {
	if (_link_context_to_decod_unit [i] < _nb_decod_unit)
	  _is_link_decod_unit_from_context [_link_context_to_decod_unit[i]] = true;
	else
	  test.error(toString(_("The context [%d] is linked with invalid decod_unit."),i));
      }

    for (uint32_t i=0; i<_nb_decod_unit; i++)
      if (_is_link_decod_unit_from_context [i] == false)
	test.error(toString(_("The decod_unit [%d] have none context as source."),i));

    log_end(Context_State,FUNCTION);

    return test;
  };

}; // end namespace context_state
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
