/*
 * $Id: Simulator_fromFile.cpp 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Configuration/include/Simulator.h"
#include "Common/include/FromString.h"
#include <fstream>

namespace morpheo {
namespace behavioural {
namespace configuration {

  using namespace XMLUtils;

#undef  FUNCTION
#define FUNCTION "Simulator::fromFile"
  void Simulator::fromFile (std::string filename)
  {
    log_begin(Configuration,FUNCTION);

    msg_printf(INFORMATION,_("Read file \"%s\"."),filename.c_str());

    std::ifstream file (filename.c_str());

    // Test the file open
    if (!file)
      throw ERRORMORPHEO(FUNCTION,toString(_("Error opening \"%s\" file.\n"),filename.c_str()));

    XML_t * _xml = new FileXMLLight<char,ClassicReferenceCounter>(file);

    // Test root node : Root name, must not a singleton, have none attribute
    testNodeName   (_xml,"parameters");
    testSingleton  (_xml,false);
    testNoAttribute(_xml);

    XMLLightVector<XML_t> vect = _xml->getNodes(); 

//     std::cout << vect << std::endl;

    for (uint32_t i=0; i<vect.size(); ++i)
      {
        XML_t * xml = vect[i];

        // Test node
        testNodeName   (xml,"parameter");
        testSingleton  (xml,true);        

        // Take attributes of this tag

        attributes_t attributes = xml->getAttributes();

//         std::cout << "Node [" << name           << "]" << std::endl;
//         std::cout << "  * nb attributes : " << xml->getAttributes().size()  << std::endl;

        attribute_t value_name  = getAttribute(xml,attributes,"name" );
        attribute_t value       = getAttribute(xml,attributes,"value");

        testAttributesEmpty(xml,attributes);

        // Insert in array
        Parameter_affectation * param = new Parameter_affectation(value_name,
                                                                  value     );

        insert(param);
      }
         
    delete _xml;

    log_end(Configuration,FUNCTION);
  };

}; // end namespace configuration
}; // end namespace behavioural
}; // end namespace morpheo              
