/*
 * $Id: Parameters_msg_error.cpp 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/include/Types.h"
#include "Behavioural/Core/Multi_Front_end/Front_end/Front_end_Glue/include/Parameters.h"
#include <sstream>

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace front_end_glue {


#undef  FUNCTION
#define FUNCTION "Front_end_Glue::msg_error"
  Parameters_test Parameters::msg_error(void)
  {
    log_begin(Front_end_Glue,FUNCTION);

    Parameters_test test ("Front_end_Glue");

    std::vector<uint32_t> translate_context_from_decod_unit [_nb_decod_unit];
    for (uint32_t i=0; i<_nb_context; ++i)
      {
        uint32_t x = _link_context_to_decod_unit[i];
        if (x < _nb_decod_unit)
          translate_context_from_decod_unit [x].push_back(i);
        else
          test.error(toString(_("context[%d] is linked with an invalid decod_unit.\n"),i));
      }

    for (uint32_t i=0; i<_nb_decod_unit; ++i)
      if (translate_context_from_decod_unit [i].size() == 0)
        test.error(toString(_("decod_unit[%d] is not linked with a ifetch_unit.\n"),i));

    log_end(Front_end_Glue,FUNCTION);

    return test;
  };

}; // end namespace front_end_glue
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
