/*
 * $Id: Priority_allocation.cpp 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Generic/Priority/include/Priority.h"

namespace morpheo                    {
namespace behavioural {
namespace generic {
namespace priority {
  
#undef  FUNCTION
#define FUNCTION "Priority::allocation"
  void Priority::allocation (void)
  {
    log_begin(Priority,FUNCTION);
    
    if (_nb_grp == 1)
      {
	reset_priority      = &morpheo::behavioural::generic::priority::Priority::reset_priority_none     ;
	transition_priority = &morpheo::behavioural::generic::priority::Priority::transition_priority_none;
      }
    else
      switch (_priority)
	{
	case PRIORITY_STATIC      : {reset_priority      = &morpheo::behavioural::generic::priority::Priority::reset_priority_static          ;
	                             transition_priority = &morpheo::behavioural::generic::priority::Priority::transition_priority_static     ;
				     break;}
	case PRIORITY_ROUND_ROBIN : {reset_priority      = &morpheo::behavioural::generic::priority::Priority::reset_priority_round_robin     ;
	                             transition_priority = &morpheo::behavioural::generic::priority::Priority::transition_priority_round_robin;
				     break;}
	default: {throw ERRORMORPHEO(FUNCTION,_("Unknow Priority scheme.\n"));}
	}

    if ((_max_nb_elt == 1) and (_nb_grp_select == 1))
      {
	reset_load_balancing      = &morpheo::behavioural::generic::priority::Priority::reset_load_balancing_none;
	transition_load_balancing = &morpheo::behavioural::generic::priority::Priority::transition_load_balancing_none;
      }
    else
      {
	if (_max_nb_elt == 1)
	  {
	    reset_load_balancing      = &morpheo::behavioural::generic::priority::Priority::reset_load_balancing_priority_only;
	    transition_load_balancing = &morpheo::behavioural::generic::priority::Priority::transition_load_balancing_priority_only;
	  }
	else
	  switch (_load_balancing)
	    {
	    case LOAD_BALANCING_BALANCE              : {reset_load_balancing      = &morpheo::behavioural::generic::priority::Priority::reset_load_balancing_balance                  ;
                                                        transition_load_balancing = &morpheo::behavioural::generic::priority::Priority::transition_load_balancing_balance             ;
							break;}
	    case LOAD_BALANCING_MAXIMUM_FOR_PRIORITY : {reset_load_balancing      = &morpheo::behavioural::generic::priority::Priority::reset_load_balancing_maximum_for_priority     ;
                                                        transition_load_balancing = &morpheo::behavioural::generic::priority::Priority::transition_load_balancing_maximum_for_priority;
							break;}
	    default: {throw ERRORMORPHEO(FUNCTION,_("Unknow Load Balancing scheme.\n"));}
	    }
      }
    

    log_end(Priority,FUNCTION);
  };

}; // end namespace priority
}; // end namespace generic
}; // end namespace behavioural
}; // end namespace morpheo              
