#ifdef VHDL_TESTBENCH
/*
 * $Id: Meta_Predictor_vhdl_testbench_port.cpp 81 2008-04-15 18:40:01Z rosiere $
 *
 * [Description ]
 * 
 */

#include "Behavioural/Stage_1_Ifetch/Predictor/Meta_Predictor/include/Meta_Predictor.h"

namespace morpheo                    {
namespace behavioural {
namespace stage_1_ifetch {
namespace predictor {
namespace meta_predictor {


  void Meta_Predictor::vhdl_testbench_port ()
  {
    log_printf(FUNC,Meta_Predictor,"vhdl_testbench_port","Begin");

    _vhdl_testbench->set_port (" in_NRESET", IN, 1);

    for (uint32_t i=0; i<_param._nb_prediction; i++)
      {
	_vhdl_testbench->set_port (" in_PREDICT_VAL_"+toString(i)+"                ", IN, 1);
	_vhdl_testbench->set_port ("out_PREDICT_ACK_"+toString(i)+"                ",OUT, 1);
	_vhdl_testbench->set_port (" in_PREDICT_ADDRESS_"+toString(i)+"            ", IN,_param._size_address);
	_vhdl_testbench->set_port ("out_PREDICT_HISTORY_"+toString(i)+"            ",OUT,_param._size_history);
    	_vhdl_testbench->set_port ("out_PREDICT_DIRECTION_"+toString(i)+"          ",OUT,1);
      }

    for (uint32_t i=0; i<_param._nb_branch_complete; i++)
      {
	_vhdl_testbench->set_port (" in_BRANCH_COMPLETE_VAL_"+toString(i)+"        ", IN, 1);
	_vhdl_testbench->set_port ("out_BRANCH_COMPLETE_ACK_"+toString(i)+"        ",OUT, 1);
	_vhdl_testbench->set_port (" in_BRANCH_COMPLETE_ADDRESS_"+toString(i)+"    ", IN,_param._size_address);
	_vhdl_testbench->set_port (" in_BRANCH_COMPLETE_HISTORY_"+toString(i)+"    ", IN,_param._size_history);
	_vhdl_testbench->set_port (" in_BRANCH_COMPLETE_DIRECTION_"+toString(i)+"  ", IN, 1);
      }

    log_printf(FUNC,Meta_Predictor,"vhdl_testbench_port","End");
  };

}; // end namespace meta_predictor
}; // end namespace predictor
}; // end namespace stage_1_ifetch

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
