#ifndef ENVIRONMENT_CACHE_CACHE_ONELEVEL_ACCESS_PORT_H
#define ENVIRONMENT_CACHE_CACHE_ONELEVEL_ACCESS_PORT_H

#include <iostream>
#include "Types.h"
#include "Cache_OneLevel_Address.h"

namespace environment {
namespace cache {
namespace cache_onelevel {

  class Access_Port
  {
  public    : bool             valid;
  public    : Address          address;
  public    : uint32_t         trdid;
  public    : type_rsp_cache_t hit;
  public    : uint32_t         num_associativity; // on hit  : update lru
  public    : uint32_t         latence;           // on miss : wait
    
    friend std::ostream& operator<< (std::ostream& output, const Access_Port &x)
    {
      output << x.valid             << " "
	     << x.hit               << " "
	     << x.address           << " "
	     << x.trdid             << " "
	     << x.num_associativity << " "
	     << x.latence;
      
      return output;
    }
  };

};
};
};
#endif
