#ifndef ENVIRONMENT_RESPONS_H
#define ENVIRONMENT_RESPONS_H

#include "Types.h"

namespace environment {

  template <class T1, class T2, class T3>
  class Respons
  {
  public : T1       trdid  ;  // number of thread
  public : T2       pktid  ;  // number of packet
  public : uint32_t nb_word;
  public : uint32_t size_word;
  public : char **  data   ;
  public : T3       error  ;
    
//   public : Respons ()
//     {
//       trdid     = 0;
//       pktid     = 0;
//       nb_word   = 0;
//       size_word = 0;
//       data      = NULL;
//       error     = 0;
//     };

  public : Respons (T1       trdid    ,
		    T2       pktid    ,
		    uint32_t nb_word  ,
		    uint32_t size_word,
		    char **  data     ,
		    T3       error 
		   )
    {
      this->trdid     = trdid;
      this->pktid     = pktid;
      this->nb_word   = nb_word;
      this->size_word = size_word;
      this->data      = new char * [nb_word];
      this->error     = error;

      for (uint32_t i=0;i < nb_word; i++)
	{
	  this->data[i] = new char [size_word];
	  memcpy(this->data[i],data[i],size_word);
	}
    };

  public : ~Respons (void)
    {
      for (uint32_t i=0; i<nb_word; i++)
	delete [] data [i];
      delete [] data;
    }

  public : friend std::ostream& operator<< (std::ostream& output, Respons x)
    {
      output << x.trdid              << " " 
	     << x.pktid              << " " 
	     << x.error              << " ";
      
      output << std::hex;
      
      for (uint32_t i = 0; i < x.nb_word; i ++)
	{
	  for (uint32_t j = x.size_word; j > 0 ; j --)
	    output << std::setw(2) << std::setfill('0') << (0xff & (static_cast<uint32_t>(x.data [i][j-1])));
	  output << " - ";
	} 
      output << std::dec;
      
      return output;
    }
  };

};
#endif
