#ifndef morpheo_behavioural_configuration_Simulator_h
#define morpheo_behavioural_configuration_Simulator_h

/*
 * $Id: Simulator.h 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Configuration/include/Parameter_affectation.h"
#include "Behavioural/Configuration/include/XMLUtils.h"
#include <map>

namespace morpheo {
namespace behavioural {
namespace configuration {

  class Simulator 
  {
    // -----[ fields ]----------------------------------------------------
  private  : std::string _filename;
  private  : std::map<std::string, Parameter_affectation *> * _array;

    // -----[ methods ]---------------------------------------------------
  public   :                      Simulator  (std::string filename);
  public   :                     ~Simulator  ();

  public   : std::string          getParam   (std::string name);
  private  : void                 insert     (Parameter_affectation * param);
  private  : void                 fromFile   (std::string filename);
  
  public   : void                 toFile     (std::string dirname=".");
  private  : XML                  toXML      (void);
  private  : std::string          print      (uint32_t depth);
  public   : friend std::ostream& operator<< (std::ostream& output,
                                              morpheo::behavioural::configuration::Simulator & x);
  };

}; // end namespace configuration
}; // end namespace behavioural
}; // end namespace morpheo              

#endif
