#ifdef SYSTEMC
/*
 * $Id: Core_Glue_genMealy_commit_event.cpp 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Core_Glue/include/Core_Glue.h"
#include "Common/include/Max.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace core_glue {


#undef  FUNCTION
#define FUNCTION "Core_Glue::genMealy_commit_event"
  void Core_Glue::genMealy_commit_event (void)
  {
    log_begin(Core_Glue,FUNCTION);
    log_function(Core_Glue,FUNCTION,_name.c_str());

    Tcontrol_t COMMIT_EVENT_FRONT_END_VAL  [_param->_nb_front_end ];
    Tcontrol_t COMMIT_EVENT_OOO_ENGINE_ACK [_param->_nb_ooo_engine];
    
    // init val/ack at 0
    for (uint32_t i=0; i<_param->_nb_front_end; ++i)
      COMMIT_EVENT_FRONT_END_VAL [i] = 0;
    for (uint32_t i=0; i<_param->_nb_ooo_engine; ++i)
      COMMIT_EVENT_OOO_ENGINE_ACK [i] = 0;

     for (uint32_t i=0; i<_param->_nb_ooo_engine; ++i)
       {
         // Take the ooo_engine.num_front_end and translate in core.num_front_end
         Tcontext_t front_end_id  = (_param->_have_port_front_end_id)?PORT_READ(in_COMMIT_EVENT_OOO_ENGINE_FRONT_END_ID [i]):0;
         Tcontext_t num_front_end = _param->_translate_ooo_engine_num_front_end [i][front_end_id];
         
          // Warning : ooo_engine.nb_inst_commit_event[i] = front_end.nb_inst_commit_event[num_front_end]
//           log_printf(TRACE,Core_Glue,FUNCTION,"  * [%d][%d] front_end_id %d, num_front_end %d",i,j,front_end_id,num_front_end);

         COMMIT_EVENT_FRONT_END_VAL [num_front_end] = PORT_READ(in_COMMIT_EVENT_OOO_ENGINE_VAL [i]);
         COMMIT_EVENT_OOO_ENGINE_ACK [i] = PORT_READ(in_COMMIT_EVENT_FRONT_END_ACK [num_front_end]);

         if (_param->_have_port_context_id)
         PORT_WRITE(out_COMMIT_EVENT_FRONT_END_CONTEXT_ID       [num_front_end], PORT_READ(in_COMMIT_EVENT_OOO_ENGINE_CONTEXT_ID       [i]));
         if (_param->_have_port_depth)
         PORT_WRITE(out_COMMIT_EVENT_FRONT_END_DEPTH            [num_front_end], PORT_READ(in_COMMIT_EVENT_OOO_ENGINE_DEPTH            [i]));
         PORT_WRITE(out_COMMIT_EVENT_FRONT_END_TYPE             [num_front_end], PORT_READ(in_COMMIT_EVENT_OOO_ENGINE_TYPE             [i]));
         PORT_WRITE(out_COMMIT_EVENT_FRONT_END_IS_DELAY_SLOT    [num_front_end], PORT_READ(in_COMMIT_EVENT_OOO_ENGINE_IS_DELAY_SLOT    [i]));
         PORT_WRITE(out_COMMIT_EVENT_FRONT_END_ADDRESS          [num_front_end], PORT_READ(in_COMMIT_EVENT_OOO_ENGINE_ADDRESS          [i]));
         PORT_WRITE(out_COMMIT_EVENT_FRONT_END_ADDRESS_EPCR     [num_front_end], PORT_READ(in_COMMIT_EVENT_OOO_ENGINE_ADDRESS_EPCR     [i]));
         PORT_WRITE(out_COMMIT_EVENT_FRONT_END_ADDRESS_EEAR_VAL [num_front_end], PORT_READ(in_COMMIT_EVENT_OOO_ENGINE_ADDRESS_EEAR_VAL [i]));
         PORT_WRITE(out_COMMIT_EVENT_FRONT_END_ADDRESS_EEAR     [num_front_end], PORT_READ(in_COMMIT_EVENT_OOO_ENGINE_ADDRESS_EEAR     [i]));
       }

    for (uint32_t i=0; i<_param->_nb_front_end; ++i)
      PORT_WRITE(out_COMMIT_EVENT_FRONT_END_VAL [i], COMMIT_EVENT_FRONT_END_VAL [i]);
    
    for (uint32_t i=0; i<_param->_nb_ooo_engine; ++i)
      PORT_WRITE(out_COMMIT_EVENT_OOO_ENGINE_ACK [i], COMMIT_EVENT_OOO_ENGINE_ACK [i]);

    log_end(Core_Glue,FUNCTION);
  };

}; // end namespace core_glue
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
