#ifndef morpheo_behavioural_core_dcache_access_Dcache_Access_h
#define morpheo_behavioural_core_dcache_access_Dcache_Access_h

/*
 * $Id: Dcache_Access.h 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#ifdef SYSTEMC
#include "systemc.h"
#endif


#include "Behavioural/Core/Dcache_Access/include/Parameters.h"
#include "Behavioural/Core/Dcache_Access/include/Types.h"
#ifdef STATISTICS
#include "Behavioural/include/Stat.h"
#endif
#include "Behavioural/include/Component.h"
#ifdef VHDL
#include "Behavioural/include/Vhdl.h"
#endif
#include "Behavioural/include/Usage.h"

#include "Common/include/ToString.h"
#include "Common/include/Debug.h"

#include "Behavioural/Generic/Priority/include/Priority.h"

#include <iostream>

namespace morpheo {
namespace behavioural {

namespace core {
namespace dcache_access {


  class Dcache_Access 
#if SYSTEMC
    : public sc_module
#endif
  {
    // -----[ fields ]----------------------------------------------------
    // Parameters
  protected : const std::string  _name;
  protected : const Parameters * _param;
  private   : const Tusage_t     _usage;

#ifdef STATISTICS
  public    : Stat                           * _stat;

  private   : counter_t                     ** _stat_nb_access;
  private   : counter_t                     ** _stat_nb_access_conflit;
#endif

  public    : Component                      * _component;
  private   : Interfaces                     * _interfaces;

#ifdef SYSTEMC
    // ~~~~~[ Interface ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    // ~~~~~[ Interface : "" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_CLOCK                      *  in_CLOCK        ;
  public    : SC_IN (Tcontrol_t)            *  in_NRESET       ;

    // ~~~~~[ Interface "dcache_req" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_OUT(Tcontrol_t           )   ** out_DCACHE_REQ_VAL         ;//[nb_dcache_port]
  public    : SC_IN (Tcontrol_t           )   **  in_DCACHE_REQ_ACK         ;//[nb_dcache_port]
  public    : SC_OUT(Tcontext_t           )   ** out_DCACHE_REQ_THREAD_ID   ;//[nb_dcache_port]
  public    : SC_OUT(Tpacket_t            )   ** out_DCACHE_REQ_PACKET_ID   ;//[nb_dcache_port]
  public    : SC_OUT(Tdcache_address_t    )   ** out_DCACHE_REQ_ADDRESS     ;//[nb_dcache_port]
  public    : SC_OUT(Tdcache_data_t       )   ** out_DCACHE_REQ_WDATA       ;//[nb_dcache_port]
  public    : SC_OUT(Tdcache_type_t       )   ** out_DCACHE_REQ_TYPE        ;//[nb_dcache_port]
									    
    // ~~~~~[ Interface "dcache_rsp" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  
  public    : SC_IN (Tcontrol_t           )   **  in_DCACHE_RSP_VAL         ;//[nb_dcache_port]
  public    : SC_OUT(Tcontrol_t           )   ** out_DCACHE_RSP_ACK         ;//[nb_dcache_port]
  public    : SC_IN (Tcontext_t           )   **  in_DCACHE_RSP_THREAD_ID   ;//[nb_dcache_port]
  public    : SC_IN (Tpacket_t            )   **  in_DCACHE_RSP_PACKET_ID   ;//[nb_dcache_port]
  public    : SC_IN (Tdcache_data_t       )   **  in_DCACHE_RSP_RDATA       ;//[nb_dcache_port]
  public    : SC_IN (Tdcache_error_t      )   **  in_DCACHE_RSP_ERROR       ;//[nb_dcache_port]

    // ~~~~~[ Interface "lsq_req" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_IN (Tcontrol_t           ) ****  in_LSQ_REQ_VAL            ;//[nb_execute_loop][nb_load_store_unit][nb_cache_access]
  public    : SC_OUT(Tcontrol_t           ) **** out_LSQ_REQ_ACK            ;//[nb_execute_loop][nb_load_store_unit][nb_cache_access]
  public    : SC_IN (Tcontext_t           ) ****  in_LSQ_REQ_THREAD_ID      ;//[nb_execute_loop][nb_load_store_unit][nb_cache_access]
  public    : SC_IN (Tpacket_t            ) ****  in_LSQ_REQ_PACKET_ID      ;//[nb_execute_loop][nb_load_store_unit][nb_cache_access]
  public    : SC_IN (Tdcache_address_t    ) ****  in_LSQ_REQ_ADDRESS        ;//[nb_execute_loop][nb_load_store_unit][nb_cache_access]
  public    : SC_IN (Tdcache_data_t       ) ****  in_LSQ_REQ_WDATA          ;//[nb_execute_loop][nb_load_store_unit][nb_cache_access]
  public    : SC_IN (Tdcache_type_t       ) ****  in_LSQ_REQ_TYPE           ;//[nb_execute_loop][nb_load_store_unit][nb_cache_access]

    // ~~~~~[ Interface "lsq_rsp" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_OUT(Tcontrol_t           ) **** out_LSQ_RSP_VAL            ;//[nb_execute_loop][nb_load_store_unit][nb_cache_access]
  public    : SC_IN (Tcontrol_t           ) ****  in_LSQ_RSP_ACK            ;//[nb_execute_loop][nb_load_store_unit][nb_cache_access]
  public    : SC_OUT(Tcontext_t           ) **** out_LSQ_RSP_THREAD_ID      ;//[nb_execute_loop][nb_load_store_unit][nb_cache_access]
  public    : SC_OUT(Tpacket_t            ) **** out_LSQ_RSP_PACKET_ID      ;//[nb_execute_loop][nb_load_store_unit][nb_cache_access]
  public    : SC_OUT(Tdcache_data_t       ) **** out_LSQ_RSP_RDATA          ;//[nb_execute_loop][nb_load_store_unit][nb_cache_access]
  public    : SC_OUT(Tdcache_error_t      ) **** out_LSQ_RSP_ERROR          ;//[nb_execute_loop][nb_load_store_unit][nb_cache_access]

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
  private   : generic::priority::Priority      * _priority;

    // ~~~~~[ Register ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    // ~~~~~[ Internal ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

#ifdef STATISTICS
  private   : uint32_t                         * _internal_DCACHE_REQ_NB_ACCESS        ; //[nb_dcache_port]
  private   : uint32_t                         * _internal_DCACHE_REQ_NB_ACCESS_CONFLIT; //[nb_dcache_port]
#endif

#endif

    // -----[ Methods ]---------------------------------------------------

#ifdef SYSTEMC
    SC_HAS_PROCESS (Dcache_Access);
#endif
  public  :          Dcache_Access              
  (
#ifdef SYSTEMC
   sc_module_name                                name,
#else					       
   std::string                                   name,
#endif					       
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
   Parameters                                  * param,
   morpheo::behavioural::Tusage_t                usage
   );
  public  :          ~Dcache_Access             (void);
					       
  private : void        allocation                (
#ifdef STATISTICS
						   morpheo::behavioural::Parameters_Statistics * param_statistics
#else
						   void
#endif
						   );
  private : void        deallocation              (void);
					       
#ifdef SYSTEMC				       
  public  : void        transition                (void);
//public  : void        genMoore                  (void);
  public  : void        genMealy_req              (void);
  public  : void        genMealy_rsp              (void);

#endif					       

#if VHDL				       
  public  : void        vhdl                      (void);
  private : void        vhdl_declaration          (Vhdl * & vhdl);
  private : void        vhdl_body                 (Vhdl * & vhdl);
#endif					       

#ifdef STATISTICS
  public  : void        statistics_allocation     (morpheo::behavioural::Parameters_Statistics * param_statistics);
  public  : void        statistics_deallocation   (void);
#endif
#if defined(STATISTICS) or defined(VHDL_TESTBENCH)
  private : void        end_cycle                 (void);
#endif
  };

}; // end namespace dcache_access
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              

#endif
