#ifdef STATISTICS
/*
 * $Id: Dcache_Access_statistics_allocation.cpp 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Dcache_Access/include/Dcache_Access.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace dcache_access {


#undef  FUNCTION
#define FUNCTION "Dcache_Access::statistics_allocation"
  void Dcache_Access::statistics_allocation (morpheo::behavioural::Parameters_Statistics * param_statistics)
  {
    log_begin(Dcache_Access,FUNCTION);

    _stat = new Stat (static_cast<std::string>(_name),
		      "Dcache_Access",
		      param_statistics);

    _stat_nb_access         = new counter_t * [_param->_nb_dcache_port];
    _stat_nb_access_conflit = new counter_t * [_param->_nb_dcache_port];

    std::string _sum_nb_access         = "";
    std::string _sum_nb_access_conflit = "";

    for (uint32_t i=0; i<_param->_nb_dcache_port; i++)
      {
	_stat_nb_access         [i] = _stat->create_counter("nb_access_"        +toString(i),"",toString(_("Total access achieved by all contexts (port %d)"),i));
	_stat_nb_access_conflit [i] = _stat->create_counter("nb_access_conflit_"+toString(i),"",toString(_("Total access conducting a conflict (port %d)"),i));

	if (i == 0)
	  {
	    _sum_nb_access         = "nb_access_0";
	    _sum_nb_access_conflit = "nb_access_conflit_0";
	  }
	else
	  {
	    _sum_nb_access         = "+ nb_access_"         +toString(i)+" "+ _sum_nb_access        ;
	    _sum_nb_access_conflit = "+ nb_access_conflit_" +toString(i)+" "+ _sum_nb_access_conflit;
	  }
	
	_stat->create_expr_percent ("percent_access_conflit_"+toString(i), "nb_access_conflit_"+toString(i), "nb_access_"+toString(i),toString(_("Percent for total access conducting a conflict (port %d)"),i));


	_stat->create_expr_average_by_cycle ("average_nb_dcache_access_"+toString(i),"- nb_access_"+toString(i)+" nb_access_conflit_"+toString(i),"",toString(_("Average of dcache access (port %d)"),i));
      }

    _stat->create_expr         ("nb_access"        , _sum_nb_access        , TYPE_COUNTER, "", _("Total access achieved by all contexts (all port)"));
    _stat->create_expr         ("nb_access_conflit", _sum_nb_access_conflit, TYPE_COUNTER, "", _("Total access conducting a conflict (all port)"));

    _stat->create_expr_percent ("percent_access_conflit", _sum_nb_access_conflit, _sum_nb_access,_("Percent for total access conducting a conflict"));

    _stat->create_expr_average_by_cycle ("average_nb_dcache_access","- nb_access nb_access_conflit","",_("Average of dcache access (all port)"));
    
    log_end(Dcache_Access,FUNCTION);
  };

}; // end namespace dcache_access
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
