/*
 * $Id: Parameters_msg_error.cpp 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/include/Types.h"
#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Network/Execution_unit_to_Write_unit/include/Parameters.h"
#include <sstream>

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace network {
namespace execution_unit_to_write_unit {


#undef  FUNCTION
#define FUNCTION "Execution_unit_to_Write_unit::msg_error"
  Parameters_test Parameters::msg_error(void)
  {
    log_printf(FUNC,Execution_unit_to_Write_unit,FUNCTION,"Begin");
    
    Parameters_test test("Execution_unit_to_Write_unit");
    
    bool is_link [_nb_execute_unit][_max_nb_execute_unit_port];
    for (uint32_t i=0; i<_nb_execute_unit; i++)
      for (uint32_t j=0; j<_nb_execute_unit_port[i]; j++)
	is_link[i][j] = false;
	
    for (uint32_t i=0; i<_nb_execute_unit; i++)
      for (uint32_t j=0; j<_nb_execute_unit_port[i]; j++)
	for (uint32_t k=0; k<_nb_write_unit; k++)
          {
            log_printf(TRACE,Execution_unit_to_Write_unit,FUNCTION,"[%d][%d][%d]",i,j,k);
            
            if (_table_routing [i][j][k] == true)
              {
                log_printf(TRACE,Execution_unit_to_Write_unit,FUNCTION," * is link");

                is_link [i][j] = true;
                break;
              }
          }

    for (uint32_t i=0; i<_nb_execute_unit; i++)
      for (uint32_t j=0; j<_nb_execute_unit_port[i]; j++)
	if (not is_link[i][j])
	  test.error(toString(_("The execute_unit [%d][%d] is link with none write_unit.\n"),i,j));
    
    for (uint32_t i=0; i<_nb_write_unit; i++)
      {
	uint32_t j;
	for (j=0; j<_nb_thread; j++)
	  if (_table_thread [i][j] == true)
	    break;
	
	if (j == _nb_thread)
	  test.error(toString(_("The write_unit [%d] have none source's thread.\n"),i));
      }	  

    if ( (_priority != PRIORITY_STATIC     ) and
	 (_priority != PRIORITY_ROUND_ROBIN))
      test.error(_("Unsupported priority scheme. It must be Static or Round Robin.\n"));

    log_printf(FUNC,Execution_unit_to_Write_unit,FUNCTION,"End");

    return test;
  };

}; // end namespace execution_unit_to_write_unit
}; // end namespace network
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
