/*
 * $Id: Parameters_print.cpp 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Network/Read_unit_to_Execution_unit/include/Parameters.h"
#include "Behavioural/include/XML.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace network {
namespace read_unit_to_execution_unit {


#undef  FUNCTION
#define FUNCTION "Read_unit_to_Execution_unit::print"
  std::string Parameters::print (uint32_t depth)
  {
    log_printf(FUNC,Read_unit_to_Execution_unit,FUNCTION,"Begin");

    XML xml ("read_unit_to_execution_unit");

    xml.balise_open("read_unit_to_execution_unit");
    xml.singleton_begin("nb_read_unit       "); xml.attribut("value",toString(_nb_read_unit       )); xml.singleton_end();
    xml.singleton_begin("nb_execute_unit    "); xml.attribut("value",toString(_nb_execute_unit    )); xml.singleton_end();
    xml.singleton_begin("nb_context         "); xml.attribut("value",toString(_nb_context         )); xml.singleton_end();
    xml.singleton_begin("nb_front_end       "); xml.attribut("value",toString(_nb_front_end       )); xml.singleton_end();
    xml.singleton_begin("nb_ooo_engine      "); xml.attribut("value",toString(_nb_ooo_engine      )); xml.singleton_end();
    xml.singleton_begin("nb_packet          "); xml.attribut("value",toString(_nb_packet          )); xml.singleton_end();
    xml.singleton_begin("size_general_data  "); xml.attribut("value",toString(_size_general_data  )); xml.singleton_end();
    xml.singleton_begin("size_special_data  "); xml.attribut("value",toString(_size_special_data  )); xml.singleton_end();
    xml.singleton_begin("nb_general_register"); xml.attribut("value",toString(_nb_general_register)); xml.singleton_end();
    xml.singleton_begin("nb_special_register"); xml.attribut("value",toString(_nb_special_register)); xml.singleton_end();
//  xml.singleton_begin("size_store_queue   "); xml.attribut("value",toString(_size_store_queue   )); xml.singleton_end();
//  xml.singleton_begin("size_load_queue    "); xml.attribut("value",toString(_size_load_queue    )); xml.singleton_end();
    xml.singleton_begin("priority           "); xml.attribut("value",toString(_priority           )); xml.singleton_end();
    xml.balise_close();

    log_printf(FUNC,Read_unit_to_Execution_unit,FUNCTION,"End");
    
    return xml.get_body(depth);
  };

#undef  FUNCTION
#define FUNCTION "Read_unit_to_Execution_unit::operator<<"
  std::ostream& operator<< (std::ostream& output_stream ,
			    morpheo::behavioural::core::multi_execute_loop::execute_loop::network::read_unit_to_execution_unit::Parameters & x)
  {
    log_printf(FUNC,Read_unit_to_Execution_unit,FUNCTION,"Begin");

    output_stream << x.print(0);
    
    log_printf(FUNC,Read_unit_to_Execution_unit,FUNCTION,"End");

    return output_stream;
  };

}; // end namespace read_unit_to_execution_unit
}; // end namespace network
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
