/*
 * $Id: Ifetch_queue_deallocation.cpp 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Ifetch_unit/Ifetch_queue/include/Ifetch_queue.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace ifetch_unit {
namespace ifetch_queue {


#undef  FUNCTION
#define FUNCTION "Ifetch_queue::deallocation"
  void Ifetch_queue::deallocation (void)
  {
    log_printf(FUNC,Ifetch_queue,FUNCTION,"Begin");

    if (usage_is_set(_usage,USE_SYSTEMC))
      {
	delete    in_CLOCK ;
	delete    in_NRESET;

	delete     in_ADDRESS_VAL                        ;
	delete    out_ADDRESS_ACK                        ;
	if (_param->_have_port_ifetch_queue_ptr)
	delete    out_ADDRESS_IFETCH_QUEUE_ID            ;
	delete []  in_ADDRESS_INSTRUCTION_ENABLE         ;
	delete     in_ADDRESS_INSTRUCTION_ADDRESS        ;
	if (_param->_have_port_inst_ifetch_ptr)
	delete     in_ADDRESS_INST_IFETCH_PTR            ;
	delete     in_ADDRESS_BRANCH_STATE               ;
	if (_param->_have_port_depth)
	delete     in_ADDRESS_BRANCH_UPDATE_PREDICTION_ID;
	delete [] out_DECOD_VAL                          ;
	delete []  in_DECOD_ACK                          ;
	delete [] out_DECOD_INSTRUCTION                  ;
	delete    out_DECOD_ADDRESS                      ;
	if (_param->_have_port_inst_ifetch_ptr)
	delete    out_DECOD_INST_IFETCH_PTR              ;
	delete    out_DECOD_BRANCH_STATE                 ;
	if (_param->_have_port_depth)
	delete    out_DECOD_BRANCH_UPDATE_PREDICTION_ID  ;
	delete    out_DECOD_EXCEPTION                    ;
	delete     in_ICACHE_RSP_VAL                     ;
	delete    out_ICACHE_RSP_ACK                     ;
	if (_param->_have_port_ifetch_queue_ptr)
	delete     in_ICACHE_RSP_PACKET_ID               ;
	delete []  in_ICACHE_RSP_INSTRUCTION             ;
	delete     in_ICACHE_RSP_ERROR                   ;
	delete     in_EVENT_RESET_VAL                    ;
	delete    out_EVENT_RESET_ACK                    ;
      }

    // ~~~~~[ Internal ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
    if (usage_is_set(_usage,USE_SYSTEMC))
      {
        delete    internal_DECOD_VAL;
        delete [] _queue;
      }

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
    delete    _component;

    log_printf(FUNC,Ifetch_queue,FUNCTION,"End");
  };

}; // end namespace ifetch_queue
}; // end namespace ifetch_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
