#ifndef test_BTB
#define test_BTB

  class entry_t
  {
  public : Tcontrol_t          _val             ;
  public : Tcontext_t          _context         ;
  public : Tcontrol_t          _address_dest_val;
  public : Tgeneral_data_t     _address_src     ;
  public : Tgeneral_data_t     _address_dest    ;
  public : Tbranch_condition_t _condition       ;
  public : Tcontrol_t          _last_take       ;
  public : Tcounter_t          _accurate        ;

  public : bool hit (morpheo::behavioural::core::multi_front_end::front_end::prediction_unit::branch_target_buffer::branch_target_buffer_register::Parameters * _param,
		     Tgeneral_data_t addr_test,
		     Tcontext_t      context)
    {
      Tgeneral_data_t addr_src_offset  = (_address_src  >> _param->_shift_offset)&_param->_mask_offset;
      Tgeneral_data_t addr_src_index   = (_address_src  >> _param->_shift_bank  )&_param->_mask_bank  ;
      Tgeneral_data_t addr_src_tag     = (_address_src  >> _param->_shift_tag   );
      
      Tgeneral_data_t addr_test_offset = (addr_test >> _param->_shift_offset)&_param->_mask_offset;
      Tgeneral_data_t addr_test_index  = (addr_test >> _param->_shift_bank  )&_param->_mask_bank  ;
      Tgeneral_data_t addr_test_tag    = (addr_test >> _param->_shift_tag   );

      bool is_hit = ( (_val             == 1               ) and
		      (_context         == context         ) and
		      (addr_test_tag    == addr_src_tag    ) and
		      (addr_test_index  == addr_src_index  ) and
		      (addr_test_offset <= addr_src_offset ));

      LABEL("address_src  (tag, index, offset) : %.8x %.8x %.8x",addr_src_tag, addr_src_index, addr_src_offset);
      LABEL("address_test (tag, index, offset) : %.8x %.8x %.8x - hit : %d",addr_test_tag, addr_test_index, addr_test_offset, is_hit);
      return is_hit;
    }
    
  public : void print (void)
    {
      LABEL("%d - %.2d %.8x %.1d %.8x %.3d %.1d %.4d", 
	    _val             ,
	    _context         ,
	    _address_src     ,
	    _address_dest_val,
	    _address_dest    ,
	    _condition       ,
	    _last_take       ,
	    _accurate        );
    }
    
  };

Tgeneral_data_t gen_addr (morpheo::behavioural::core::multi_front_end::front_end::prediction_unit::branch_target_buffer::branch_target_buffer_register::Parameters * _param,
			  Tgeneral_data_t index)
{
  Tgeneral_data_t addr_tag     = (rand()%(_param->_associativity)) << _param->_shift_tag   ;
  Tgeneral_data_t addr_index   = (index &_param->_mask_bank        ) << _param->_shift_bank  ;
  Tgeneral_data_t addr_offset  = (rand()&_param->_mask_offset      ) << _param->_shift_offset;

  LABEL("gen_addr     (tag, index, offset) : %.8x %.8x %.8x",addr_tag, addr_index, addr_offset);

  return (addr_tag    |
	  addr_index  |
	  addr_offset );
}

#endif
