/*
 * $Id$
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Prediction_unit_Glue/include/Parameters.h"
#include "Common/include/Max.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace prediction_unit {
namespace prediction_unit_glue {


#undef  FUNCTION
#define FUNCTION "Prediction_unit_Glue::Parameters"
  Parameters::Parameters (uint32_t   nb_context            ,
			  uint32_t   nb_decod_unit         ,
// 			  uint32_t   nb_ooo_engine         ,
			  uint32_t   size_address          ,
			  uint32_t * nb_instruction        ,
			  uint32_t * size_depth            ,
			  uint32_t * nb_inst_decod         ,
// 			  uint32_t * nb_inst_update        ,
			  uint32_t   nb_inst_branch_predict,
			  uint32_t   nb_inst_branch_decod  ,
			  uint32_t   nb_inst_branch_update ,
                          bool       is_toplevel
                          )
  {
    log_printf(FUNC,Prediction_unit_Glue,FUNCTION,"Begin");

    _nb_context                = nb_context     ;
    _nb_instruction            = nb_instruction ;
//  _size_depth                = size_depth     ;
    _array_size_depth          = size_depth     ;
    _nb_decod_unit             = nb_decod_unit  ;
    _nb_inst_decod             = nb_inst_decod  ;
//  _nb_ooo_engine             = nb_ooo_engine  ;
//  _nb_inst_update            = nb_inst_update ;
    _nb_inst_branch_predict    = nb_inst_branch_predict;
    _nb_inst_branch_decod      = nb_inst_branch_decod  ;
    _nb_inst_branch_update     = nb_inst_branch_update ;
      
    test();

    if (is_toplevel)
      {
        _size_instruction_address  = size_address;
        _size_context_id           = log2(_nb_context);
        _size_depth                = max<uint32_t>(size_depth,_nb_context);
        _size_inst_ifetch_ptr      = log2(max<uint32_t>(_nb_instruction,_nb_context));

        _have_port_context_id      = (_size_context_id > 0);
        _have_port_depth           = (_size_depth > 0);
	_have_port_inst_ifetch_ptr = (_size_inst_ifetch_ptr > 0);

        copy ();
      }

    log_printf(FUNC,Prediction_unit_Glue,FUNCTION,"End");
  };
  
// #undef  FUNCTION
// #define FUNCTION "Prediction_unit_Glue::Parameters (copy)"
//   Parameters::Parameters (Parameters & param)
//   {
//     log_printf(FUNC,Prediction_unit_Glue,FUNCTION,"Begin");
//     test();
//     log_printf(FUNC,Prediction_unit_Glue,FUNCTION,"End");
//   };

#undef  FUNCTION
#define FUNCTION "Prediction_unit_Glue::~Parameters"
  Parameters::~Parameters () 
  {
    log_printf(FUNC,Prediction_unit_Glue,FUNCTION,"Begin");
    log_printf(FUNC,Prediction_unit_Glue,FUNCTION,"End");
  };

#undef  FUNCTION
#define FUNCTION "Prediction_unit_Glue::copy"
  void Parameters::copy (void) 
  {
    log_printf(FUNC,Prediction_unit_Glue,FUNCTION,"Begin");
    log_printf(FUNC,Prediction_unit_Glue,FUNCTION,"End");
  };

}; // end namespace prediction_unit_glue
}; // end namespace prediction_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
