/*
 * $Id: Parameters.cpp 95 2008-12-16 16:24:26Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/include/Parameters.h"
#include "Common/include/Max.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace prediction_unit {


#undef  FUNCTION
#define FUNCTION "Prediction_unit::Parameters"
  Parameters::Parameters (uint32_t     nb_context                    ,
			  uint32_t     nb_decod_unit                 ,
			  uint32_t     size_address                  ,
			  uint32_t *   nb_instruction                ,//[nb_context]
			  uint32_t *   nb_inst_decod                 ,//[nb_decod_unit]
			  uint32_t     nb_inst_branch_predict        ,
			  uint32_t     nb_inst_branch_decod          ,
			  uint32_t     nb_inst_branch_update         ,
			  uint32_t     nb_inst_branch_complete       ,
			  uint32_t     btb_size_queue                ,
			  uint32_t     btb_associativity             ,
			  uint32_t     btb_size_counter              ,
			  Tvictim_t    btb_victim_scheme             ,
			  Tpredictor_t dir_predictor_scheme          ,
			  bool         dir_have_bht               [3],
			  uint32_t     dir_bht_size_shifter       [3],
			  uint32_t     dir_bht_nb_shifter         [3],
			  bool         dir_have_pht               [3],
			  uint32_t     dir_pht_size_counter       [3],
			  uint32_t     dir_pht_nb_counter         [3],
			  uint32_t     dir_pht_size_address_share [3],
			  uint32_t *   ras_size_queue                ,//[nb_context]
			  uint32_t *   upt_size_queue                ,//[nb_context]
			  uint32_t *   ufpt_size_queue               ,//[nb_context]
                          bool         is_toplevel
			  )
  {
    log_printf(FUNC,Prediction_unit,FUNCTION,"Begin");
    
    _nb_context                 = nb_context                ;
    _nb_decod_unit              = nb_decod_unit             ;
    _size_address               = size_address              ;
    _nb_instruction             = nb_instruction            ;
    _nb_inst_decod              = nb_inst_decod             ;
    _nb_inst_branch_predict     = nb_inst_branch_predict    ;
    _nb_inst_branch_decod       = nb_inst_branch_decod      ;
    _nb_inst_branch_update      = nb_inst_branch_update     ;
    _nb_inst_branch_complete    = nb_inst_branch_complete   ;
    _btb_size_queue             = btb_size_queue            ;
    _btb_associativity          = btb_associativity         ;
    _btb_size_counter           = btb_size_counter          ;
    _btb_victim_scheme          = btb_victim_scheme         ;
    _dir_predictor_scheme       = dir_predictor_scheme      ;
    for (uint32_t i=0; i<3; i++)
      {
	_dir_have_bht               [i] = dir_have_bht               [i];
	_dir_bht_size_shifter       [i] = dir_bht_size_shifter       [i];
	_dir_bht_nb_shifter         [i] = dir_bht_nb_shifter         [i];
	_dir_have_pht               [i] = dir_have_pht               [i];
	_dir_pht_size_counter       [i] = dir_pht_size_counter       [i];
	_dir_pht_nb_counter         [i] = dir_pht_nb_counter         [i];
	_dir_pht_size_address_share [i] = dir_pht_size_address_share [i];
      }
    _ras_size_queue             = ras_size_queue            ;
    _upt_size_queue             = upt_size_queue            ;
    _ufpt_size_queue            = ufpt_size_queue           ;
    
    _array_size_depth           = new uint32_t [_nb_context];
    _size_ras_index             = new uint32_t [_nb_context];

    for (uint32_t i=0; i<_nb_context; i++)
      {
	_array_size_depth [i] = log2(_upt_size_queue [i]);
	_size_ras_index   [i] = log2(_ras_size_queue [i]);
      }

    _param_glue = new morpheo::behavioural::core::multi_front_end::front_end::prediction_unit::prediction_unit_glue   ::Parameters 
      (_nb_context            ,
       _nb_decod_unit         ,
       _size_address          ,
       _nb_instruction        ,
       _array_size_depth      ,
       _nb_inst_decod         ,
       _nb_inst_branch_predict,
       _nb_inst_branch_decod  ,
       _nb_inst_branch_update );

    _param_btb  = new morpheo::behavioural::core::multi_front_end::front_end::prediction_unit::branch_target_buffer   ::Parameters 
      (_nb_context            ,
       _nb_instruction        ,
       _btb_size_queue        ,
       _btb_associativity     ,
       _size_address          ,
       _btb_size_counter      ,
       _nb_inst_branch_predict,
       _nb_inst_branch_decod  ,
       _nb_inst_branch_update ,
       _btb_victim_scheme     );
    
    _param_dir  = new morpheo::behavioural::core::multi_front_end::front_end::prediction_unit::direction              ::Parameters 
      (_dir_predictor_scheme      ,
       _nb_inst_branch_predict    ,
       _nb_inst_branch_update     ,
       _size_address              ,
       _dir_have_bht              ,
       _dir_bht_size_shifter      ,
       _dir_bht_nb_shifter        ,
       _dir_have_pht              ,
       _dir_pht_size_counter      ,
       _dir_pht_nb_counter        ,
       _dir_pht_size_address_share);

    _size_history      = _param_dir->_size_history;
    _have_port_history = (_size_history > 0);

    _param_ras  = new morpheo::behavioural::core::multi_front_end::front_end::prediction_unit::return_address_stack   ::Parameters 
      (_nb_context            ,
       _ras_size_queue        ,
       _size_address          ,
       _nb_inst_branch_predict,
       _nb_inst_branch_decod  ,
       _nb_inst_branch_update );

    _param_upt  = new morpheo::behavioural::core::multi_front_end::front_end::prediction_unit::update_prediction_table::Parameters 
      (_nb_context             ,
       _upt_size_queue         ,
       _ufpt_size_queue        ,
       _size_address           ,
       _nb_inst_branch_predict ,
       _nb_inst_branch_decod   ,
       _nb_inst_branch_complete,
       _nb_inst_branch_update  ,
       _size_history           ,
       _size_ras_index         );


    if (is_toplevel)
      {
        _size_context_id           = log2(_nb_context);
        _size_depth                = max<uint32_t>(_array_size_depth,_nb_context);
        _size_inst_ifetch_ptr      = log2(max<uint32_t>(_nb_instruction,_nb_context));
        _size_instruction_address  = size_address;
//      _size_nb_inst_decod        = ;
//      _size_nb_inst_commit       = ;
//      _size_ifetch_queue_ptr     = ;
   
        _have_port_context_id      = (_size_context_id > 0);
        _have_port_depth           = (_size_depth  > 0);
        _have_port_inst_ifetch_ptr = _size_inst_ifetch_ptr > 0;
//      _have_port_ifetch_queue_ptr= _size_ifetch_queue_ptr > 0;

        copy ();
      }

    test();
    log_printf(FUNC,Prediction_unit,FUNCTION,"End");
  };
  
// #undef  FUNCTION
// #define FUNCTION "Prediction_unit::Parameters (copy)"
//   Parameters::Parameters (Parameters & param)
//   {
//     log_printf(FUNC,Prediction_unit,FUNCTION,"Begin");
//     test();
//     log_printf(FUNC,Prediction_unit,FUNCTION,"End");
//   };

#undef  FUNCTION
#define FUNCTION "Prediction_unit::~Parameters"
  Parameters::~Parameters () 
  {
    log_printf(FUNC,Prediction_unit,FUNCTION,"Begin");
  
    delete _param_btb;
    delete _param_dir;
    delete _param_ras;
    delete _param_upt;
    delete _param_glue;

    delete [] _array_size_depth;
    delete [] _size_ras_index;

    log_printf(FUNC,Prediction_unit,FUNCTION,"End");
  };

#undef  FUNCTION
#define FUNCTION "Prediction_unit::copy"
  void Parameters::copy (void) 
  {
    log_printf(FUNC,Prediction_unit,FUNCTION,"Begin");
  
    COPY(_param_btb );
    COPY(_param_dir );
    COPY(_param_ras );
    COPY(_param_upt );
    COPY(_param_glue);

    log_printf(FUNC,Prediction_unit,FUNCTION,"End");
  };

}; // end namespace prediction_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
