/*
 * $Id: main.cpp 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Commit_unit/SelfTest/include/test.h"

#define NB_PARAMS 15

void usage (int argc, char * argv[])
{
  err (_("<Usage> %s name_instance list_params.\n"),argv[0]);
  err (_("list_params is :\n"));
  err (_(" * nb_front_end                                       (uint32_t         )\n"));
  err (_(" * nb_context              [nb_front_end]             (uint32_t         )\n"));
  err (_(" * nb_rename_unit                                     (uint32_t         )\n"));
  err (_(" * size_queue                                         (uint32_t         )\n"));
  err (_(" * nb_bank                                            (uint32_t         )\n"));
  err (_(" * nb_inst_insert          [nb_rename_unit]           (uint32_t         )\n"));
  err (_(" * nb_inst_retire          [nb_rename_unit]           (uint32_t         )\n"));
  err (_(" * nb_inst_commit                                     (uint32_t         )\n"));
  err (_(" * nb_inst_reexecute                                  (uint32_t         )\n"));
  err (_(" * nb_inst_branch_complete                            (uint32_t         )\n"));
  err (_(" * nb_branch_speculated    [nb_front_end][nb_context] (uint32_t         )\n"));
  err (_(" * size_general_data                                  (uint32_t         )\n"));
  err (_(" * size_store_queue_ptr                               (uint32_t         )\n"));
  err (_(" * size_load_queue_ptr                                (uint32_t         )\n"));
  err (_(" * size_general_register                              (uint32_t         )\n"));
  err (_(" * size_special_register                              (uint32_t         )\n"));
  err (_(" * priority                                           (Tpriority_t      )\n"));
  err (_(" * load_balancing                                     (Tload_balancing_t)\n"));
  err (_(" * nb_rename_unit_select                              (uint32_t         )\n"));

  exit (1);
}

#ifndef SYSTEMC
int main    (int argc, char * argv[])
#else
int sc_main (int argc, char * argv[])
#endif
{
  if (argc <= static_cast<int>(2+NB_PARAMS))
    usage (argc, argv);

  uint32_t x = 1;

  string name = argv[x++];

  uint32_t     _nb_front_end            = fromString<uint32_t>(argv[x++]);


  if (argc <= static_cast<int>(2+NB_PARAMS+_nb_front_end))
    usage (argc, argv);

  uint32_t     _sum_nb_context = 0;
  uint32_t   * _nb_context              = new uint32_t [_nb_front_end];
  for (uint32_t i=0; i<_nb_front_end; i++)
    {
      _nb_context [i] = fromString<uint32_t>(argv[x++]);
      _sum_nb_context += _nb_context [i];
    }
  uint32_t     _nb_rename_unit          = fromString<uint32_t>(argv[x++]);

  if (argc != static_cast<int>(2+NB_PARAMS+1*_nb_front_end+_sum_nb_context+2*_nb_rename_unit))
    usage (argc, argv);

  uint32_t     _size_queue              = fromString<uint32_t>(argv[x++]);
  uint32_t     _nb_bank                 = fromString<uint32_t>(argv[x++]);
  uint32_t   * _nb_inst_insert          = new uint32_t [_nb_rename_unit];
  for (uint32_t i=0; i<_nb_rename_unit; i++)
    _nb_inst_insert [i] = fromString<uint32_t>(argv[x++]);
  uint32_t   * _nb_inst_retire          = new uint32_t [_nb_rename_unit];
  for (uint32_t i=0; i<_nb_rename_unit; i++)
    _nb_inst_retire [i] = fromString<uint32_t>(argv[x++]);
  uint32_t     _nb_inst_commit    	= fromString<uint32_t>(argv[x++]);
  uint32_t     _nb_inst_reexecute	= fromString<uint32_t>(argv[x++]);
  uint32_t     _nb_inst_branch_complete = fromString<uint32_t>(argv[x++]);
  uint32_t **  _nb_branch_speculated    = new uint32_t * [_nb_front_end];

  for (uint32_t i=0; i<_nb_front_end; i++)
    {
      _nb_branch_speculated [i] = new uint32_t [_nb_context [i]];
      for (uint32_t j=0; j<_nb_context [i]; j++)
	_nb_branch_speculated [i][j] = fromString<uint32_t>(argv[x++]);
    }

  uint32_t          _size_general_data       = fromString<uint32_t         >(argv[x++]);
  uint32_t          _size_store_queue_ptr    = fromString<uint32_t         >(argv[x++]);
  uint32_t          _size_load_queue_ptr     = fromString<uint32_t         >(argv[x++]);
  uint32_t          _size_general_register   = fromString<uint32_t         >(argv[x++]);
  uint32_t          _size_special_register   = fromString<uint32_t         >(argv[x++]);
  Tpriority_t       _priority                = fromString<Tpriority_t      >(argv[x++]);
  Tload_balancing_t _load_balancing          = fromString<Tload_balancing_t>(argv[x++]);
  uint32_t          _nb_rename_unit_select   = fromString<uint32_t         >(argv[x++]);

  int _return = EXIT_SUCCESS;
  try 
    {
      morpheo::behavioural::core::multi_ooo_engine::ooo_engine::commit_unit::Parameters * param = new morpheo::behavioural::core::multi_ooo_engine::ooo_engine::commit_unit::Parameters
	(_nb_front_end            ,
	 _nb_context              ,
	 _nb_rename_unit          ,
	 _size_queue              ,
	 _nb_bank                 ,
	 _nb_inst_insert          ,
	 _nb_inst_retire          ,
	 _nb_inst_commit          ,
	 _nb_inst_reexecute       ,
	 _nb_inst_branch_complete ,
	 _nb_branch_speculated    ,
	 _size_general_data       ,
	 _size_store_queue_ptr    ,
	 _size_load_queue_ptr     ,
	 _size_general_register   ,
	 _size_special_register   ,
	 _priority                ,
	 _load_balancing          ,
	 _nb_rename_unit_select   ,
         true // is_toplevel
	 );
      
//       msg(_("%s"),param->print(0).c_str());
      
      test (name,param);
    }
  catch (morpheo::ErrorMorpheo & error)
    {
      msg (_("%s"),error.what ());
      _return = EXIT_FAILURE;
    }
  
  try 
    {
      if (_return == EXIT_SUCCESS)
	TEST_OK("No error");
      else
	TEST_KO("A lot of error");
    }
  catch (morpheo::ErrorMorpheo & error)
    {
//       msg (_("<%s> :\n%s"),name.c_str(), error.what ());
      _return = EXIT_FAILURE;
    }

  delete [] _nb_context    ;
  delete [] _nb_inst_insert;
  delete [] _nb_inst_retire;
  for (uint32_t i=0; i<_nb_front_end; i++)
    delete [] _nb_branch_speculated [i];
  delete [] _nb_branch_speculated;

  return (_return);
}
