#ifdef SYSTEMC
/*
 * $Id: OOO_Engine_Glue_genMealy_insert.cpp 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/OOO_Engine_Glue/include/OOO_Engine_Glue.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace ooo_engine_glue {


#undef  FUNCTION
#define FUNCTION "OOO_Engine_Glue::genMealy_insert"
  void OOO_Engine_Glue::genMealy_insert (void)
  {
    log_begin(OOO_Engine_Glue,FUNCTION);
    log_function(OOO_Engine_Glue,FUNCTION,_name.c_str());

    uint32_t x=0;
    for (uint32_t i=0; i<_param->_nb_rename_unit; ++i)
      for (uint32_t j=0; j<_param->_nb_inst_insert[i]; ++j)
        {
          Tcontext_t         FRONT_END_ID          = (_param->_have_port_front_end_id  )?_param->_translate_front_end_id_from_rename_unit[i][PORT_READ(in_INSERT_RENAME_UNIT_FRONT_END_ID [i][j])]:0;
          Tcontext_t         CONTEXT_ID            = (_param->_have_port_context_id    )?PORT_READ(in_INSERT_RENAME_UNIT_CONTEXT_ID           [i][j]):0;
          Ttype_t            TYPE                  = PORT_READ(in_INSERT_RENAME_UNIT_TYPE                  [i][j]);
          Toperation_t       OPERATION             = PORT_READ(in_INSERT_RENAME_UNIT_OPERATION             [i][j]);
          Tcontrol_t         NO_EXECUTE            = PORT_READ(in_INSERT_RENAME_UNIT_NO_EXECUTE            [i][j]);
          Tcontrol_t         HAS_IMMEDIAT          = PORT_READ(in_INSERT_RENAME_UNIT_HAS_IMMEDIAT          [i][j]);
          Tgeneral_data_t    IMMEDIAT              = PORT_READ(in_INSERT_RENAME_UNIT_IMMEDIAT              [i][j]);
          Tlsq_ptr_t         STORE_QUEUE_PTR_WRITE = PORT_READ(in_INSERT_RENAME_UNIT_STORE_QUEUE_PTR_WRITE [i][j]);
          Tlsq_ptr_t         LOAD_QUEUE_PTR_WRITE  = (_param->_have_port_load_queue_ptr)?PORT_READ(in_INSERT_RENAME_UNIT_LOAD_QUEUE_PTR_WRITE [i][j]):0;
          Tcontrol_t         READ_RA               = PORT_READ(in_INSERT_RENAME_UNIT_READ_RA               [i][j]);
          Tgeneral_address_t NUM_REG_RA_PHY        = PORT_READ(in_INSERT_RENAME_UNIT_NUM_REG_RA_PHY        [i][j]);
          Tcontrol_t         READ_RB               = PORT_READ(in_INSERT_RENAME_UNIT_READ_RB               [i][j]);
          Tgeneral_address_t NUM_REG_RB_PHY        = PORT_READ(in_INSERT_RENAME_UNIT_NUM_REG_RB_PHY        [i][j]);
          Tcontrol_t         READ_RC               = PORT_READ(in_INSERT_RENAME_UNIT_READ_RC               [i][j]);
          Tspecial_address_t NUM_REG_RC_PHY        = PORT_READ(in_INSERT_RENAME_UNIT_NUM_REG_RC_PHY        [i][j]);
          Tcontrol_t         WRITE_RD              = PORT_READ(in_INSERT_RENAME_UNIT_WRITE_RD              [i][j]);
          Tgeneral_address_t NUM_REG_RD_PHY_OLD    = PORT_READ(in_INSERT_RENAME_UNIT_NUM_REG_RD_PHY_OLD    [i][j]);
          Tgeneral_address_t NUM_REG_RD_PHY_NEW    = PORT_READ(in_INSERT_RENAME_UNIT_NUM_REG_RD_PHY_NEW    [i][j]);
          Tcontrol_t         WRITE_RE              = PORT_READ(in_INSERT_RENAME_UNIT_WRITE_RE              [i][j]);
          Tspecial_address_t NUM_REG_RE_PHY_OLD    = PORT_READ(in_INSERT_RENAME_UNIT_NUM_REG_RE_PHY_OLD    [i][j]);
          Tspecial_address_t NUM_REG_RE_PHY_NEW    = PORT_READ(in_INSERT_RENAME_UNIT_NUM_REG_RE_PHY_NEW    [i][j]);

          Tgeneral_address_t general_address_msb   = FRONT_END_ID << _param->_size_general_register;
          Tspecial_address_t special_address_msb   = FRONT_END_ID << _param->_size_special_register;
          
          PORT_WRITE(out_INSERT_RD_USE                            [x]   ,WRITE_RD);
          PORT_WRITE(out_INSERT_RD_NUM_REG                        [x]   ,general_address_msb | NUM_REG_RD_PHY_NEW);
          PORT_WRITE(out_INSERT_RE_USE                            [x]   ,WRITE_RE);
          PORT_WRITE(out_INSERT_RE_NUM_REG                        [x]   ,special_address_msb | NUM_REG_RE_PHY_NEW);

          if (_param->_have_port_front_end_id)
          PORT_WRITE(out_INSERT_COMMIT_UNIT_FRONT_END_ID          [i][j],FRONT_END_ID         );
          if (_param->_have_port_context_id)
          PORT_WRITE(out_INSERT_COMMIT_UNIT_CONTEXT_ID            [i][j],CONTEXT_ID           );
//        PORT_WRITE(out_INSERT_COMMIT_UNIT_RENAME_UNIT_ID        [i][j],RENAME_UNIT_ID       );
          PORT_WRITE(out_INSERT_COMMIT_UNIT_TYPE                  [i][j],TYPE                 );
          PORT_WRITE(out_INSERT_COMMIT_UNIT_OPERATION             [i][j],OPERATION            );
          PORT_WRITE(out_INSERT_COMMIT_UNIT_NO_EXECUTE            [i][j],NO_EXECUTE           );
          PORT_WRITE(out_INSERT_COMMIT_UNIT_STORE_QUEUE_PTR_WRITE [i][j],STORE_QUEUE_PTR_WRITE);
          if (_param->_have_port_load_queue_ptr)
          PORT_WRITE(out_INSERT_COMMIT_UNIT_LOAD_QUEUE_PTR_WRITE  [i][j],LOAD_QUEUE_PTR_WRITE );
          PORT_WRITE(out_INSERT_COMMIT_UNIT_READ_RA               [i][j],READ_RA              );
          PORT_WRITE(out_INSERT_COMMIT_UNIT_NUM_REG_RA_PHY        [i][j],NUM_REG_RA_PHY       );
          PORT_WRITE(out_INSERT_COMMIT_UNIT_READ_RB               [i][j],READ_RB              );
          PORT_WRITE(out_INSERT_COMMIT_UNIT_NUM_REG_RB_PHY        [i][j],NUM_REG_RB_PHY       );
          PORT_WRITE(out_INSERT_COMMIT_UNIT_READ_RC               [i][j],READ_RC              );
          PORT_WRITE(out_INSERT_COMMIT_UNIT_NUM_REG_RC_PHY        [i][j],NUM_REG_RC_PHY       );
          PORT_WRITE(out_INSERT_COMMIT_UNIT_WRITE_RD              [i][j],WRITE_RD             );
          PORT_WRITE(out_INSERT_COMMIT_UNIT_NUM_REG_RD_PHY_OLD    [i][j],NUM_REG_RD_PHY_OLD   );
          PORT_WRITE(out_INSERT_COMMIT_UNIT_NUM_REG_RD_PHY_NEW    [i][j],NUM_REG_RD_PHY_NEW   );
          PORT_WRITE(out_INSERT_COMMIT_UNIT_WRITE_RE              [i][j],WRITE_RE             );
          PORT_WRITE(out_INSERT_COMMIT_UNIT_NUM_REG_RE_PHY_OLD    [i][j],NUM_REG_RE_PHY_OLD   );
          PORT_WRITE(out_INSERT_COMMIT_UNIT_NUM_REG_RE_PHY_NEW    [i][j],NUM_REG_RE_PHY_NEW   );

          if (_param->_have_port_front_end_id)
          PORT_WRITE(out_INSERT_ISSUE_QUEUE_FRONT_END_ID          [i][j],FRONT_END_ID         );
          if (_param->_have_port_context_id)
          PORT_WRITE(out_INSERT_ISSUE_QUEUE_CONTEXT_ID            [i][j],CONTEXT_ID           );
          PORT_WRITE(out_INSERT_ISSUE_QUEUE_TYPE                  [i][j],TYPE                 );
          PORT_WRITE(out_INSERT_ISSUE_QUEUE_OPERATION             [i][j],OPERATION            );
          PORT_WRITE(out_INSERT_ISSUE_QUEUE_STORE_QUEUE_PTR_WRITE [i][j],STORE_QUEUE_PTR_WRITE);
          if (_param->_have_port_load_queue_ptr)
          PORT_WRITE(out_INSERT_ISSUE_QUEUE_LOAD_QUEUE_PTR_WRITE  [i][j],LOAD_QUEUE_PTR_WRITE );
          PORT_WRITE(out_INSERT_ISSUE_QUEUE_HAS_IMMEDIAT          [i][j],HAS_IMMEDIAT         );
          PORT_WRITE(out_INSERT_ISSUE_QUEUE_IMMEDIAT              [i][j],IMMEDIAT             );
          PORT_WRITE(out_INSERT_ISSUE_QUEUE_READ_RA               [i][j],READ_RA              );
          PORT_WRITE(out_INSERT_ISSUE_QUEUE_NUM_REG_RA            [i][j],general_address_msb | NUM_REG_RA_PHY);
          PORT_WRITE(out_INSERT_ISSUE_QUEUE_READ_RB               [i][j],READ_RB              );
          PORT_WRITE(out_INSERT_ISSUE_QUEUE_NUM_REG_RB            [i][j],general_address_msb | NUM_REG_RB_PHY);
          PORT_WRITE(out_INSERT_ISSUE_QUEUE_READ_RC               [i][j],READ_RC              );
          PORT_WRITE(out_INSERT_ISSUE_QUEUE_NUM_REG_RC            [i][j],special_address_msb | NUM_REG_RC_PHY);
          PORT_WRITE(out_INSERT_ISSUE_QUEUE_WRITE_RD              [i][j],WRITE_RD             );
          PORT_WRITE(out_INSERT_ISSUE_QUEUE_NUM_REG_RD            [i][j],general_address_msb | NUM_REG_RD_PHY_NEW);
          PORT_WRITE(out_INSERT_ISSUE_QUEUE_WRITE_RE              [i][j],WRITE_RE             );
          PORT_WRITE(out_INSERT_ISSUE_QUEUE_NUM_REG_RE            [i][j],special_address_msb | NUM_REG_RE_PHY_NEW);

          x ++;
        }

    log_end(OOO_Engine_Glue,FUNCTION);
  };

}; // end namespace ooo_engine_glue
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
