#ifndef morpheo_behavioural_core_Core_h
#define morpheo_behavioural_core_Core_h

/*
 * $Id: Core.h 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#ifdef SYSTEMC
#include "systemc.h"
#endif

#include "Behavioural/Core/Multi_Front_end/Front_end/include/Front_end.h"
#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/include/OOO_Engine.h"
#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/include/Execute_loop.h"
#include "Behavioural/Core/Icache_Access/include/Icache_Access.h"
#include "Behavioural/Core/Dcache_Access/include/Dcache_Access.h"
#include "Behavioural/Core/Core_Glue/include/Core_Glue.h"

#include "Behavioural/Core/include/Parameters.h"
#include "Behavioural/include/Types.h"

#ifdef STATISTICS
#include "Behavioural/include/Stat.h"
#endif
#include "Behavioural/include/Component.h"
#ifdef VHDL
#include "Behavioural/include/Vhdl.h"
#endif
#include "Behavioural/include/Usage.h"

#include "Common/include/ToString.h"
#include "Common/include/Debug.h"

#include <iostream>

namespace morpheo {
namespace behavioural {
namespace core {


  class Core 
#if SYSTEMC
    : public sc_module
#endif
  {
    // -----[ fields ]----------------------------------------------------
    // Parameters
  protected : const std::string  _name;
  protected : const Parameters * _param;
  private   : const Tusage_t     _usage;

#ifdef STATISTICS
  public    : Stat                           * _stat;
#endif

  public    : Component                      * _component;
  private   : Interfaces                     * _interfaces;

#ifdef SYSTEMC
    // ~~~~~[ Interface ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    // ~~~~~[ Interface : "" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_CLOCK                        *  in_CLOCK        ;
  public    : SC_IN (Tcontrol_t)              *  in_NRESET       ;

    // ~~~~~[ Interface "icache_req" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_OUT(Tcontrol_t           )  ** out_ICACHE_REQ_VAL         ;//[nb_icache_port]
  public    : SC_IN (Tcontrol_t           )  **  in_ICACHE_REQ_ACK         ;//[nb_icache_port]
  public    : SC_OUT(Tcontext_t           )  ** out_ICACHE_REQ_THREAD_ID   ;//[nb_icache_port]
  public    : SC_OUT(Tpacket_t            )  ** out_ICACHE_REQ_PACKET_ID   ;//[nb_icache_port]
  public    : SC_OUT(Ticache_address_t    )  ** out_ICACHE_REQ_ADDRESS     ;//[nb_icache_port]
  public    : SC_OUT(Ticache_type_t       )  ** out_ICACHE_REQ_TYPE        ;//[nb_icache_port]
									    
    // ~~~~~[ Interface "icache_rsp" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  
  public    : SC_IN (Tcontrol_t           )  **  in_ICACHE_RSP_VAL         ;//[nb_icache_port]
  public    : SC_OUT(Tcontrol_t           )  ** out_ICACHE_RSP_ACK         ;//[nb_icache_port]
  public    : SC_IN (Tcontext_t           )  **  in_ICACHE_RSP_THREAD_ID   ;//[nb_icache_port]
  public    : SC_IN (Tpacket_t            )  **  in_ICACHE_RSP_PACKET_ID   ;//[nb_icache_port]
  public    : SC_IN (Ticache_instruction_t) ***  in_ICACHE_RSP_INSTRUCTION ;//[nb_icache_port][icache_nb_instruction]
  public    : SC_IN (Ticache_error_t      )  **  in_ICACHE_RSP_ERROR       ;//[nb_icache_port]

    // ~~~~~[ Interface "dcache_req" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_OUT(Tcontrol_t           )  ** out_DCACHE_REQ_VAL         ;//[nb_dcache_port]
  public    : SC_IN (Tcontrol_t           )  **  in_DCACHE_REQ_ACK         ;//[nb_dcache_port]
  public    : SC_OUT(Tcontext_t           )  ** out_DCACHE_REQ_THREAD_ID   ;//[nb_dcache_port]
  public    : SC_OUT(Tpacket_t            )  ** out_DCACHE_REQ_PACKET_ID   ;//[nb_dcache_port]
  public    : SC_OUT(Tdcache_address_t    )  ** out_DCACHE_REQ_ADDRESS     ;//[nb_dcache_port]
  public    : SC_OUT(Tdcache_data_t       )  ** out_DCACHE_REQ_WDATA       ;//[nb_dcache_port]
  public    : SC_OUT(Tdcache_type_t       )  ** out_DCACHE_REQ_TYPE        ;//[nb_dcache_port]
									    
    // ~~~~~[ Interface "dcache_rsp" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  
  public    : SC_IN (Tcontrol_t           )  **  in_DCACHE_RSP_VAL         ;//[nb_dcache_port]
  public    : SC_OUT(Tcontrol_t           )  ** out_DCACHE_RSP_ACK         ;//[nb_dcache_port]
  public    : SC_IN (Tcontext_t           )  **  in_DCACHE_RSP_THREAD_ID   ;//[nb_dcache_port]
  public    : SC_IN (Tpacket_t            )  **  in_DCACHE_RSP_PACKET_ID   ;//[nb_dcache_port]
  public    : SC_IN (Tdcache_data_t       )  **  in_DCACHE_RSP_RDATA       ;//[nb_dcache_port]
  public    : SC_IN (Tdcache_error_t      )  **  in_DCACHE_RSP_ERROR       ;//[nb_dcache_port]

    // ~~~~~[ Interface : "interrupt" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_IN (Tcontrol_t           )  **  in_INTERRUPT_ENABLE       ;//[nb_thread] - Interrupt Exception

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
  private   : core::multi_front_end::front_end::Front_end          ** _component_front_end;
  private   : core::multi_ooo_engine::ooo_engine::OOO_Engine       ** _component_ooo_engine;
  private   : core::multi_execute_loop::execute_loop::Execute_loop ** _component_execute_loop;
  private   : core::icache_access::Icache_Access                    * _component_icache_access;
  private   : core::dcache_access::Dcache_Access                    * _component_dcache_access;
  private   : core::core_glue::Core_Glue                            * _component_glue;

    // ~~~~~[ Register ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    // ~~~~~[ Internal ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#endif

    // -----[ Methods ]---------------------------------------------------

#ifdef SYSTEMC
    SC_HAS_PROCESS (Core);
#endif
  public  :          Core              
  (
#ifdef SYSTEMC
   sc_module_name                                name,
#else					       
   std::string                                   name,
#endif					       
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
   Parameters                                  * param,
   morpheo::behavioural::Tusage_t                usage
   );
  public  :          ~Core             (void);


  private : void        allocation                (
#ifdef STATISTICS
						   morpheo::behavioural::Parameters_Statistics * param_statistics
#else
						   void
#endif
						   );
  private : void        deallocation              (void);
					       
#ifdef SYSTEMC				       
# if defined(STATISTICS) or defined(VHDL_TESTBENCH)
  public  : void        transition                (void);
# endif					       
#endif					       

#if VHDL				       
  public  : void        vhdl                      (void);
#endif					       

#ifdef STATISTICS
  public  : void        statistics_allocation     (morpheo::behavioural::Parameters_Statistics * param_statistics);
  public  : void        statistics_deallocation   (void);
#endif
#if defined(STATISTICS) or defined(VHDL_TESTBENCH)
  private : void        end_cycle                 (void);
#endif
  };

}; // end namespace core
}; // end namespace behavioural
}; // end namespace morpheo              

#endif
