/*
 * $Id: Parameters_msg_error.cpp 82 2008-05-01 16:48:45Z rosiere $
 *
 * [Description ]
 * 
 */

#include "Behavioural/Generic/Shifter/include/Parameters.h"
#include "Behavioural/Generic/Shifter/include/Types.h"
#include <sstream>

namespace morpheo {
namespace behavioural {
namespace generic {
namespace shifter {

  Parameters_test Parameters::msg_error(void)
  {
    Parameters_test test ("Shifter");

    if (_size_data < 2)
      test.error("size_data must be > 1\n");
    
    if (is_positive(_nb_port) == false)
      test.error("nb_port must be > 0\n");
    
    if (_shift_value > _size_data) 
      test.error("shift_value must be < size_data\n");	
    
    if ( (_rotate == internal_rotate) && (_carry != internal_logic))
      test.error("Incompatible parameters : internal_rotate have never carry (must be set at \"internal_logic\"\n");
    
    if (_type_completion_bool && (_size_data_completion != 1))
      test.error("Incompatible parameters : you can't have the type of port in_SHIFTER_COMPLETION at bool. Because, This port must be more bits\n");
      
    return test;
  };

}; // end namespace shifter
}; // end namespace generic
}; // end namespace behavioural
}; // end namespace morpheo              
