/*
 * $Id: test.cpp 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 * Test
 */

#define NB_ITERATION  1024
#define CYCLE_MAX     (128*NB_ITERATION)

#include "Behavioural/Generic/Sort/SelfTest/include/test.h"
#include "Common/include/Test.h"
#include "Common/include/BitManipulation.h"
#include "Behavioural/include/Allocation.h"

class entry_t
{
public : Tcontrol_t _val ;
public : Tdata_t    _data;
};


void test (string name,
	   morpheo::behavioural::generic::sort::Parameters * _param)
{
  msg(_("<%s> : Simulation SystemC.\n"),name.c_str());

#ifdef STATISTICS
  morpheo::behavioural::Parameters_Statistics * _parameters_statistics = new morpheo::behavioural::Parameters_Statistics (5,50);
#endif

  Tusage_t _usage = USE_ALL;

//   _usage = usage_unset(_usage,USE_SYSTEMC              );
//   _usage = usage_unset(_usage,USE_VHDL                 );
//   _usage = usage_unset(_usage,USE_VHDL_TESTBENCH       );
//   _usage = usage_unset(_usage,USE_VHDL_TESTBENCH_ASSERT);
//   _usage = usage_unset(_usage,USE_POSITION             );
//   _usage = usage_unset(_usage,USE_STATISTICS           );
//   _usage = usage_unset(_usage,USE_INFORMATION          );

  Sort * _Sort = new Sort (name.c_str(),
#ifdef STATISTICS
			   _parameters_statistics,
#endif
			   _param,
			   _usage);
  
#ifdef SYSTEMC
  /*********************************************************************
   * Dclarations des signaux
   *********************************************************************/
  string rename;

  sc_clock              *  in_CLOCK  = new sc_clock ("clock", 1.0, 0.5);	 
  sc_signal<Tcontrol_t> *  in_NRESET = new sc_signal<Tcontrol_t> ("NRESET");

  ALLOC1_SC_SIGNAL( in_INPUT_VAL   ," in_INPUT_VAL   ",Tcontrol_t,_param->_nb_input );
  ALLOC1_SC_SIGNAL( in_INPUT_DATA  ," in_INPUT_DATA  ",Tdata_t   ,_param->_nb_input );
  ALLOC1_SC_SIGNAL(out_OUTPUT_VAL  ,"out_OUTPUT_VAL  ",Tcontrol_t,_param->_nb_output);
  ALLOC1_SC_SIGNAL(out_OUTPUT_INDEX,"out_OUTPUT_INDEX",Taddress_t,_param->_nb_output);
  ALLOC1_SC_SIGNAL(out_OUTPUT_DATA ,"out_OUTPUT_DATA ",Tdata_t   ,_param->_nb_output);
  
  /********************************************************
   * Instanciation
   ********************************************************/
  
  msg(_("<%s> : Instanciation of _Sort.\n"),name.c_str());

  (*(_Sort->in_CLOCK))        (*(in_CLOCK));
  (*(_Sort->in_NRESET))       (*(in_NRESET));

  INSTANCE1_SC_SIGNAL(_Sort, in_INPUT_VAL   ,_param->_nb_input );
  INSTANCE1_SC_SIGNAL(_Sort, in_INPUT_DATA  ,_param->_nb_input );
  INSTANCE1_SC_SIGNAL(_Sort,out_OUTPUT_VAL  ,_param->_nb_output);
  if (_param->_have_port_index_out)
  INSTANCE1_SC_SIGNAL(_Sort,out_OUTPUT_INDEX,_param->_nb_output);
  if (_param->_have_port_data_out)
  INSTANCE1_SC_SIGNAL(_Sort,out_OUTPUT_DATA ,_param->_nb_output);

  msg(_("<%s> : Start Simulation ............\n"),name.c_str());
    
  Time * _time = new Time();

  /********************************************************
   * Simulation - Begin
   ********************************************************/

  // Initialisation

  const uint32_t seed = 0;
//const uint32_t seed = static_cast<uint32_t>(time(NULL));

  srand(seed);

  entry_t tab [_param->_nb_input];

  SC_START(0);
  LABEL("Initialisation");

  LABEL("Reset");
  in_NRESET->write(0);
  SC_START(5);
  in_NRESET->write(1);  
  SC_START(1);

  LABEL("Loop of Test");

  for (uint32_t iteration=0; iteration<NB_ITERATION; iteration ++)
    {
      LABEL("Iteration %d",iteration);

      for (uint32_t i=0; i<_param->_nb_input; i++)
	{
	  tab [i]._val  = rand ()%2;
	  tab [i]._data = range<Tdata_t>(rand(),_param->_size_data);

	  in_INPUT_VAL  [i]->write(tab [i]._val );
	  in_INPUT_DATA [i]->write(tab [i]._data);

	  LABEL("INPUT  [%d] %d - %d",i, tab [i]._val, tab [i]._data);
	}

      SC_START(1);

      if (_param->_ascending)
	{
	  Tdata_t data_min = 0;
	  for (uint32_t i=0; i<_param->_nb_output; i++)
	    {
	      bool     find = false;
	      Tdata_t  data = range<Tdata_t>(static_cast<Tdata_t>(-1),_param->_size_data);
	      uint32_t ptr  = 0;
	      // find max
// 	      LABEL(" * data_min  : %d",data_min);

	      for (uint32_t j=0; j<_param->_nb_input; j++)
		{
// 		  LABEL("tab[%d]._val  : %d",j,tab [j]._val );
// 		  LABEL("tab[%d]._data : %d",j,tab [j]._data);
// 		  LABEL(" * find      : %d",find);
// 		  LABEL(" * data      : %d",data);
// 		  LABEL(" * ptr       : %d",ptr );

		if ((tab [j]._val  == 1) and
		    (tab [j]._data >= data_min) and
		    (tab [j]._data <= data))
		  {
		    if (not (find and (data == tab [j]._data)))
		      ptr  = j;

		    data = tab [j]._data;
		    find = true;
		  }
		}

// 	      LABEL("-------------");
// 	      LABEL(" * find      : %d",find);
// 	      LABEL(" * data      : %d",data);
// 	      LABEL(" * ptr       : %d",ptr );

	      data_min = data;
	      tab [ptr]._val = false;

	      LABEL("OUTPUT [%d] %d %d - %d",i, out_OUTPUT_VAL [i]->read(), out_OUTPUT_DATA [i]->read(), out_OUTPUT_INDEX [i]->read());

	      TEST(Tcontrol_t,out_OUTPUT_VAL   [i]->read(),find);

	      if (find)
		{
	      if (_param->_have_port_index_out)
	      TEST(Taddress_t,out_OUTPUT_INDEX [i]->read(),ptr );
	      if (_param->_have_port_data_out)
	      TEST(Tdata_t   ,out_OUTPUT_DATA  [i]->read(),data);
		}
	    }
	}
    }

  /********************************************************
   * Simulation - End
   ********************************************************/

  TEST_OK ("End of Simulation");
  delete _time;

  msg(_("<%s> : ............ Stop Simulation\n"),name.c_str());

  delete in_CLOCK;
  delete in_NRESET;

  delete []  in_INPUT_VAL   ;
  delete []  in_INPUT_DATA  ;
  delete [] out_OUTPUT_VAL  ;
  delete [] out_OUTPUT_INDEX;
  delete [] out_OUTPUT_DATA ;
#endif

  delete _Sort;
#ifdef STATISTICS
  delete _parameters_statistics;
#endif
}
