#ifndef _FILE_XMLLIGHT_H
#define _FILE_XMLLIGHT_H

#include "Behavioural/include/AbstractXMLLight.h"
#include <fstream>

using std::basic_ifstream;

namespace morpheo {
	namespace XMLUtils {
	//**************************************Class Declaration*******************************************//
	
		template<typename char_type, typename reference_counter_type = ClassicReferenceCounter>
		class FileXMLLight : public AbstractXMLLight<char_type, reference_counter_type> {
		public:
			inline explicit FileXMLLight(const basic_ifstream<char_type> & inputFileStream, 
				IXMLLight<char_type,reference_counter_type> * parent = NULL );
		};
	
	//*****************************************Inline Implementation*************************************//
		template < typename char_type, typename ref_counter_type>
		FileXMLLight<char_type,ref_counter_type>::FileXMLLight
		(const basic_ifstream<char_type> & inputFileStream, IXMLLight<char_type,ref_counter_type> * parent) 
			: AbstractXMLLight<char_type, ref_counter_type>(inputFileStream, parent) {}
		
	}
}
#endif //_FILE_XMLLIGHT_H
