#ifdef STATISTICS
#include "Behavioural/include/Stat.h"

namespace morpheo {
namespace behavioural {

  void Stat::create_expr (std::string varname,
			  std::string expr,
			  bool each_cycle)
  {
    if (is_valid_var (varname))
      throw(ERRORMORPHEO("Stat::create_expr",_("Variable is not valid.")));
    
    expr_t expression;

    expression.variable   = (*_list_operand) [varname].counter;
    expression.expression = string2tree(expr);
    expression.each_cycle = each_cycle;

    _list_expr->push_back(expression);
  }

  void Stat::create_expr (std::string    varname,
			  std::string    expr,
			  counter_type_t type,
			  std::string    unit,
			  std::string    description,
			  bool           each_cycle)
  {
    if (type == TYPE_COUNTER)
      create_counter (varname,unit,description);
    else
      create_variable(varname);

    create_expr(varname, expr, each_cycle);
  }


  void Stat::create_expr_average (std::string varname,
				  std::string expr_sum,
				  std::string expr_deps,
				  std::string unit,
				  std::string description)
  {
    create_counter(varname,unit,description);
    create_expr   (varname, "/ "+expr_sum+" "+expr_deps, false);
  }

  void Stat::create_expr_average_by_cycle (std::string varname,
					   std::string expr_sum,
					   std::string unit,
					   std::string description)
  {
    create_expr_average (varname, expr_sum, "cycle", unit, description);
  }

  void Stat::create_expr_percent (std::string varname,
				  std::string expr_sum,
				  std::string expr_max,
				  std::string description)
  {
    create_counter(varname,"%",description);
    create_expr   (varname, "/ * "+expr_sum+" 100 "+expr_max, false);
  }


};
};
#endif
