#ifndef Morpheo_FromString_h
#define Morpheo_FromString_h

/*
 * $Id: FromString.h 88 2008-12-10 18:31:39Z rosiere $
 *
 * [Description ]
 * 
 */

// #include <iosfwd>
// #include <sstream>
// #include <iomanip>
#include <string>
// #include <limits>

namespace morpheo {
  
  template<typename T> inline T        fromString             (const std::string& x)
  {
    return static_cast<T>(x.c_str());
  }
  
  template<>           inline uint32_t fromString<uint32_t>   (const std::string& x)
  {
    return static_cast<uint32_t>(atoi(x.c_str()));
  }

  template<>           inline uint64_t fromString<uint64_t>   (const std::string& x)
  {
    return static_cast<uint64_t>(atoll(x.c_str()));
  }

  template<>           inline double   fromString<double>     (const std::string& x)
  {
    return static_cast<double>(atof(x.c_str()));
  }

  template<>           inline bool     fromString<bool>       (const std::string& x)
  {
    return atoi(x.c_str())!=0;
  }
  
}; // end namespace morpheo              

#endif
