/*
 *
 * [desc.]
 */
#include "Tools/Viewer/Bdd/include/BaseV.h"

namespace morpheo{
namespace tools{
namespace viewer{
namespace bdd{  
  /*
   * search and find the signal 
   * top : actual component is viewed on screen
   * c: the component (source) which is connected to the dest
   * dest : the port destination informations
   */
  morpheo::tools::viewer::bdd::Signal *BaseV::getSignal(BaseP *top,string c,morpheo::tools::viewer::bdd::PortMap *dest)
  {
    int srcX,srcY,destX,destY;
    Architecture *aa=top->getArchitecture();
    morpheo::tools::viewer::bdd::Component x=aa->getComponent(c);
    // cout << dest->getName() <<endl;  
    morpheo::tools::viewer::bdd::Port *p= x.searchPort(dest->getName());
    srcX=p->get_x();
    srcY=p->get_y();
    morpheo::tools::viewer::bdd::Port *pm;
    if(dest->getComponent()==(top->getEntity())->getName())
      {
	//cout << dest->getComponent() <<endl;  
	morpheo::tools::viewer::bdd::BaseP res=get_BasePos(dest->getComponent());
	pm=(res.getEntity())->searchPort(dest->getPort());
      }
    else
      {
	x=aa->getComponent(dest->getComponent());
	pm= x.searchPort(dest->getPort());
      }
    destX=pm->get_x();
    destY=pm->get_y();
    
    morpheo::tools::viewer::bdd::Signal *s=new Signal(srcX,srcY,destX,destY);
    return s;
  }


};//end bdd
};//end viewer
};//end tools
};//end morpheo
