/********************************************
 * files               : asm_003_extend.s
 * authors             : Rosiere Mathieu
 * date                : 2006/06/20
 ********************************************
 * input               : -
 * output              : 1 test OK
 *                       0 test KO
 ********************************************
 * test                : l.extbs, l.extbz, l.exthz, l.exths
 * warning             : instruction ok 
 *                         l.addi
 *                         l.and
 *                         l.jal
 *                         l.jr
 *                         l.lwz
 *                         l.ori
 *                         l.sw
 ********************************************
 */
	.file	"asm_003_extend.s"
	.section .text
	.align	4

	.global _asm_003_extend
_asm_003_extend :	
	/* save context */
	l.addi	r1,r1,-12
	l.sw	0 (r1),r20
	l.sw	4 (r1),r21
	l.sw	8 (r1),r22
	/* Return is KO (default)*/
	l.and   r11,r0,r0

	/* WARNING  : gcc don't compile if l.extXX have not two source register */

	/* step 1   : test extend byte */

	/* step 1.1 : test with a variable not signed */

	l.ori   r20,r0,0x007F

	l.extbz	r22,r20
	l.sfeq	r22,r20
	l.bnf	_asm_003_extend_ko
	l.nop	1

	l.extbs	r22,r20
	l.sfeq	r22,r20
	l.bnf	_asm_003_extend_ko
	l.nop	2
	
	/* step 1.2 : test with a varibale signed */
	l.ori   r20,r0,0x0080
	
	l.movhi r21,0xFFFF
	l.ori   r21,r21,0xFF80

	l.extbz	r22,r20
	l.sfeq	r22,r20
	l.bnf	_asm_003_extend_ko
	l.nop	3

	l.extbs	r22,r20
	l.sfeq	r22,r21
	l.bnf	_asm_003_extend_ko
	l.nop	4

	/* step 2   : test extend half word */

	/* step 2.1 : test with a variable not signed */

	l.ori   r20,r0,0x7FFF

	l.exthz	r22,r20
	l.sfeq	r22,r20
	l.bnf	_asm_003_extend_ko
	l.nop	5

	l.exths	r22,r20
	l.sfeq	r22,r20
	l.bnf	_asm_003_extend_ko
	l.nop	6
	
	/* step 2.2 : test with a variable signed */
	l.ori   r20,r0,0x8000
	
	l.movhi r21,0xFFFF
	l.ori   r21,r21,0x8000

	l.exthz	r22,r20
	l.sfeq	r22,r20
	l.bnf	_asm_003_extend_ko
	l.nop	7

	l.exths	r22,r20
	l.sfeq	r22,r21
	l.bnf	_asm_003_extend_ko
	l.nop	8

_asm_003_extend_ok :	
	l.addi	r11,r0,1
_asm_003_extend_ko :
	
	/* load context */
	l.lwz	r22,8 (r1)
	l.lwz	r21,4 (r1)
	l.lwz	r20,0 (r1)
	l.jr	r9
	l.addi	r1,r1,12
