/*
 * Test_026
 *
 * end_ko : infinite_loop
 * end_ok : Write in R1 the stop address and stop an data
 *          The store in the destination of an jump
 * start  : Test l.sw / l.lws (l.lwz)
 */
	
	.file	"crt0.s"
	/*
	.section .vector
	*/
	.section .text
	.align	4	

/* ---[ 0x0  : Print a error ]------------------------------------------- */

	.org 0x0
_end_ko        :        
	l.movhi r1,     hi(_tty)
	l.ori   r1, r1, lo(_tty)
        l.sw    4(r1), r1 /* stop address */
_infinite_loop :        
        l.j	_infinite_loop
        l.nop

_end_ok :
	l.movhi r1,     hi(_tty)
	l.ori   r1, r1, lo(_tty)
        l.sw    4(r1), r0 /* stop address */


/* ---[ 0x100: RESET exception ]----------------------------------------- */
        .org 0x100
	.global _start
_start:
	l.movhi r1,     hi(_stack) /* address */
	l.ori   r1, r1, lo(_stack)

	l.movhi r2,     hi(0xdeadbeef) /* data */
	l.ori   r2, r2, lo(0xdeadbeef)

        /* Store 10 values */
        l.and   r3, r2, r2
        
        l.sw    - 0(r1), r3
        l.addi  r3, r3, 1

        l.sw    - 4(r1), r3
        l.addi  r3, r3, 1

        l.sw    - 8(r1), r3
        l.addi  r3, r3, 1

        l.sw    -12(r1), r3
        l.addi  r3, r3, 1
        
        l.sw    -16(r1), r3
        l.addi  r3, r3, 1

        l.sw    -20(r1), r3
        l.addi  r3, r3, 1

        l.sw    -24(r1), r3
        l.addi  r3, r3, 1

        l.sw    -28(r1), r3
        l.addi  r3, r3, 1

        l.sw    -32(r1), r3
        l.addi  r3, r3, 1

        l.sw    -36(r1), r3
        l.addi  r3, r3, 1

        /* Load 10 values */
        l.addi  r3, r3, -1 /* increase too much*/

        l.lwz   r4, -36(r1)
        l.sfeq  r4, r3
        l.bnf   _end_ko
        l.addi  r3, r3, -1

        l.lwz   r4, -32(r1)
        l.sfeq  r4, r3
        l.bnf   _end_ko
        l.addi  r3, r3, -1

        l.lwz   r4, -28(r1)
        l.sfeq  r4, r3
        l.bnf   _end_ko
        l.addi  r3, r3, -1

        l.lwz   r4, -24(r1)
        l.sfeq  r4, r3
        l.bnf   _end_ko
        l.addi  r3, r3, -1

        l.lwz   r4, -20(r1)
        l.sfeq  r4, r3
        l.bnf   _end_ko
        l.addi  r3, r3, -1

        l.lwz   r4, -16(r1)
        l.sfeq  r4, r3
        l.bnf   _end_ko
        l.addi  r3, r3, -1

        l.lwz   r4, -12(r1)
        l.sfeq  r4, r3
        l.bnf   _end_ko
        l.addi  r3, r3, -1

        l.lwz   r4, - 8(r1)
        l.sfeq  r4, r3
        l.bnf   _end_ko
        l.addi  r3, r3, -1

        l.lwz   r4, - 4(r1)
        l.sfeq  r4, r3
        l.bnf   _end_ko
        l.addi  r3, r3, -1

        l.lwz   r4, - 0(r1)
        l.sfeq  r4, r3
        l.bnf   _end_ko
        l.addi  r3, r3, -1

        /* Store 10 values */
        l.and   r3, r2, r2
        
        l.sw    - 0(r1), r3
        l.addi  r3, r3, 1

        l.sw    - 4(r1), r3
        l.addi  r3, r3, 1

        l.sw    - 8(r1), r3
        l.addi  r3, r3, 1

        l.sw    -12(r1), r3
        l.addi  r3, r3, 1
        
        l.sw    -16(r1), r3
        l.addi  r3, r3, 1

        l.sw    -20(r1), r3
        l.addi  r3, r3, 1

        l.sw    -24(r1), r3
        l.addi  r3, r3, 1

        l.sw    -28(r1), r3
        l.addi  r3, r3, 1

        l.sw    -32(r1), r3
        l.addi  r3, r3, 1

        l.sw    -36(r1), r3
        l.addi  r3, r3, 1

        /* Load 10 values */
        l.addi  r3, r3, -1 /* increase too much*/

        l.lws   r4, -36(r1)
        l.sfeq  r4, r3
        l.bnf   _end_ko
        l.addi  r3, r3, -1

        l.lws   r4, -32(r1)
        l.sfeq  r4, r3
        l.bnf   _end_ko
        l.addi  r3, r3, -1

        l.lws   r4, -28(r1)
        l.sfeq  r4, r3
        l.bnf   _end_ko
        l.addi  r3, r3, -1

        l.lws   r4, -24(r1)
        l.sfeq  r4, r3
        l.bnf   _end_ko
        l.addi  r3, r3, -1

        l.lws   r4, -20(r1)
        l.sfeq  r4, r3
        l.bnf   _end_ko
        l.addi  r3, r3, -1

        l.lws   r4, -16(r1)
        l.sfeq  r4, r3
        l.bnf   _end_ko
        l.addi  r3, r3, -1

        l.lws   r4, -12(r1)
        l.sfeq  r4, r3
        l.bnf   _end_ko
        l.addi  r3, r3, -1

        l.lws   r4, - 8(r1)
        l.sfeq  r4, r3
        l.bnf   _end_ko
        l.addi  r3, r3, -1

        l.lws   r4, - 4(r1)
        l.sfeq  r4, r3
        l.bnf   _end_ko
        l.addi  r3, r3, -1

        l.lws   r4, - 0(r1)
        l.sfeq  r4, r3
        l.bnf   _end_ko
        l.addi  r3, r3, -1
        
        /* end test */
        l.j     _end_ok
        l.nop
