/*
 * Test_049
 *
 * end_ko : infinite_loop
 * end_ok : Write in R1 the stop address and stop an data
 *          The store in the destination of an jump
 * start  : Test dependencies between access memory
 */
	
	.file	"crt0.s"
	/*
	.section .vector
	*/
	.section .text
	.align	4	

/* ---[ 0x0  : Print a error ]------------------------------------------- */

	.org 0x0
_end_ko        :        
	l.movhi r1,     hi(_tty)
	l.ori   r1, r1, lo(_tty)
        l.sw    4(r1), r1 /* stop address */
_infinite_loop :        
        l.j	_infinite_loop
        l.nop

_end_ok :
	l.movhi r1,     hi(_tty)
	l.ori   r1, r1, lo(_tty)
        l.sw    4(r1), r0 /* stop address */


/* ---[ 0x100: RESET exception ]----------------------------------------- */
        .org 0x100
	.global _start
_start:
	l.movhi r1,     hi(_stack) /* address */
	l.ori   r1, r1, lo(_stack)

 	l.movhi r2,     hi(0x00000010) /* iteration */
	l.ori   r2, r2, lo(0x00000010)

	l.movhi r3,     hi(0xdeadbeef) /* data 1 */
	l.ori   r3, r3, lo(0xdeadbeef)
	l.movhi r4,     hi(0x12345678) /* data 2 */
	l.ori   r4, r4, lo(0x12345678)
        
        l.j     _loop1_store_test
        l.and   r20, r0, r0 /* iterator */
_loop1_store_body :
        l.srli  r5, r3, 0   /* deadbeef */
        l.srli  r6, r3, 8   /* 00deadbe */
        l.srli  r7, r3, 16  /* 0000dead */
        l.srli  r8, r4, 8   /* 00123456 */
        l.srli  r9, r4, 16  /* 00001234 */
        
        l.sb    +3(r1), r5
        l.sb    +2(r1), r6
        l.lhz   r10, +2(r1)
        l.sh    +0(r1), r7
        l.lwz   r11, +0(r1)

        l.sw    -4(r1), r3
        l.sh    -2(r1), r1
        l.sb    -1(r1), r4
        l.sh    -4(r1), r9
        l.sb    -2(r1), r8
        l.lwz   r12, -4(r1)
        
        l.sfeq  r11, r3
        l.bnf   _end_ko
        l.nop
        
        l.exthz r11, r3
        l.sfeq  r10, r11
        l.bnf   _end_ko
        l.nop

        l.sfeq  r12, r4
        l.bnf   _end_ko
        l.nop
        
        l.addi  r3, r3,  1
        l.rori  r3, r3,  1
        l.addi  r4, r4,  1
        l.rori  r4, r4,  1

_loop1_store_test :        
        l.sfeq  r20, r2
        l.bnf   _loop1_store_body
        l.addi  r20, r20, 1
        
        /* end test */
        l.j     _end_ok
        l.nop
