/*
 * Test_023
 *
 * end_ko : infinite_loop
 * end_ok : Write in R1 the stop address and stop an data
 *          The store in the destination of an jump
 * start  : Test l.jalr
 */
	
	.file	"crt0.s"
	/*
	.section .vector
	*/
	.section .text
	.align	4	

/* ---[ 0x0  : Print a error ]------------------------------------------- */

	.org 0x0
_end_ko        :        
	l.movhi r1,     hi(_tty)
	l.ori   r1, r1, lo(_tty)
        l.sw    4(r1), r1 /* stop address */
_infinite_loop :        
        l.j	_infinite_loop
        l.nop

_end_ok :
	l.movhi r1,     hi(_tty)
	l.ori   r1, r1, lo(_tty)
        l.sw    4(r1), r0 /* stop address */


/* ---[ 0x100: RESET exception ]----------------------------------------- */
        .org 0x100
	.global _start
_start:
        l.and r1, r0, r0 /* counter 1 */
        l.ori r2, r0, 10 /* limit */
        l.j     _go0
        l.nop
        l.j     _end_ko
        l.nop
        
        .org 0x140
_go0    :
        l.nop
        l.nop
	l.movhi r3,     hi(_go1)
	l.ori   r3, r3, lo(_go1)
        l.jalr  r3
        l.sfeqi r9, 0x158
        l.j     _end_ko
        l.nop

        .org 0x180
_go2    :
        l.bnf   _end_ko
        l.nop
	l.movhi r3,     hi(_go3)
	l.ori   r3, r3, lo(_go3)
        l.jalr  r3
        l.sfeqi r9, 0x198
        l.j     _end_ko
        l.nop

        .org 0x1c0
_go1    :
        l.bnf   _end_ko
        l.nop
	l.movhi r3,     hi(_go2)
	l.ori   r3, r3, lo(_go2)
        l.jalr  r3
        l.sfeqi r9,0x1d8
        l.j     _end_ko
        l.nop

        .org 0x200
_go3    :
        l.bnf   _end_ko
        l.nop
	l.movhi r3,     hi(_go4)
	l.ori   r3, r3, lo(_go4)
        l.jalr  r3
        l.sfeqi r9,0x218
        l.j     _end_ko
        l.nop
        
        .org 0x240
_go4    :
        l.bnf   _end_ko
        l.nop
        l.addi  r1, r1, 1
        l.sfeq  r1, r2
        l.bf    _end_ok
        l.nop
        l.j     _go0
        l.nop
        l.j     _end_ko
        l.nop
