#ifndef morpheo_behavioural_Selftest_h
#define morpheo_behavioural_Selftest_h

/*
 * $Id: Selftest.h 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/include/Allocation.h"
#include "Common/include/FromString.h"
#include "Common/include/Debug.h"

// ======================================================================
// =====[ ALLOCATION / DELETE of ARRAY ]=================================
// ======================================================================

#define AFFECT0(var,type,argv,x)                  \
  var = morpheo::fromString<type>(argv[x++]);

#define AFFECT1(var,type,argv,x,s1)               \
  for (uint32_t it1=0; it1<s1; ++it1)                     \
    {                                                     \
      var [it1] = morpheo::fromString<type>(argv[x++]);   \
    }

#define AFFECT2(var,type,argv,x,s1,s2)                  \
  for (uint32_t it1=0; it1<s1; ++it1)                           \
    for (uint32_t it2=0; it2<s2; ++it2)                         \
      {                                                         \
        var [it1][it2] = morpheo::fromString<type>(argv[x++]);  \
      }

#define AFFECT3(var,type,argv,x,s1,s2,s3)                       \
  for (uint32_t it1=0; it1<s1; ++it1)                                   \
    for (uint32_t it2=0; it2<s2; ++it2)                                 \
      for (uint32_t it3=0; it3<s3; ++it3)                               \
        {                                                               \
          var [it1][it2][it3] = morpheo::fromString<type>(argv[x++]);   \
        }

#define AFFECT4(var,type,argv,x,s1,s2,s3,s4)                    \
  for (uint32_t it1=0; it1<s1; ++it1)                                   \
    for (uint32_t it2=0; it2<s2; ++it2)                                 \
      for (uint32_t it3=0; it3<s3; ++it3)                               \
        for (uint32_t it4=0; it4<s4; ++it4)                             \
          {                                                             \
            var [it1][it2][it3][it4] = morpheo::fromString<type>(argv[x++]); \
          }


#define SELFTEST0(var,type,argv,x)              \
  AFFECT0(var,type,argv,x);                     \
  
#define SELFTEST1(var,type,argv,x,s1)           \
  ALLOC1(var,type,s1);                          \
  AFFECT1(var,type,argv,x,s1);

#define SELFTEST2(var,type,argv,x,s1,s2)                \
  ALLOC2(var,type,s1,s2);                               \
  AFFECT2(var,type,argv,x,s1,s2);

#define SELFTEST3(var,type,argv,x,s1,s2,s3)             \
  ALLOC3(var,type,s1,s2,s3);                            \
  AFFECT3(var,type,argv,x,s1,s2,s3);

#define SELFTEST4(var,type,argv,x,s1,s2,s3,s4)          \
  ALLOC4(var,type,s1,s2,s3,s4);                         \
  AFFECT4(var,type,argv,x,s1,s2,s3,s4);

#endif
