#ifndef ENVIRONMENT_CACHE_CACHE_ONELEVEL_TAG_H
#define ENVIRONMENT_CACHE_CACHE_ONELEVEL_TAG_H

#include <iostream>
#include <iomanip>

namespace environment {
namespace cache {
namespace cache_onelevel {

  class Tag
  {
  public    : bool            valid    ; // tag is valid ?
  public    : uint32_t        address  ; // address
  public    : uint32_t        trdid    ; // owner thread identification
  public    : uint32_t        index_lru; // to select victim
    
    friend std::ostream& operator<< (std::ostream& output, const Tag &x)
    {
      output << x.valid     << " "
	     << std::hex << std::setw(8) << std::setfill('0') << x.address   << " " << std::dec
	     << x.trdid     << " "
	     << x.index_lru;
      
      return output;
    }
  };

};
};
};
#endif
