/*
 * $Id: Address_management_deallocation.cpp 101 2009-01-15 17:19:08Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Ifetch_unit/Address_management/include/Address_management.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace ifetch_unit {
namespace address_management {


#undef  FUNCTION
#define FUNCTION "Address_management::deallocation"
  void Address_management::deallocation (void)
  {
    log_printf(FUNC,Address_management,FUNCTION,"Begin");

    if (usage_is_set(_usage,USE_SYSTEMC))
      {
	delete    in_CLOCK ;
	delete    in_NRESET;

	delete    out_ADDRESS_VAL                        ;
	delete     in_ADDRESS_ACK                        ;
	delete    out_ADDRESS_INSTRUCTION_ADDRESS        ;
	delete [] out_ADDRESS_INSTRUCTION_ENABLE         ;
	if (_param->_have_port_inst_ifetch_ptr)
	delete    out_ADDRESS_INST_IFETCH_PTR            ;
	delete    out_ADDRESS_BRANCH_STATE               ;
	if (_param->_have_port_depth)
	delete    out_ADDRESS_BRANCH_UPDATE_PREDICTION_ID;
	delete    out_PREDICT_VAL                        ;
	delete     in_PREDICT_ACK                        ;
	delete    out_PREDICT_PC_PREVIOUS                ;
	delete    out_PREDICT_PC_CURRENT                 ;
	delete    out_PREDICT_PC_CURRENT_IS_DS_TAKE      ;
	delete     in_PREDICT_PC_NEXT                    ;
	delete     in_PREDICT_PC_NEXT_IS_DS_TAKE         ;
	delete []  in_PREDICT_INSTRUCTION_ENABLE         ;
	if (_param->_have_port_inst_ifetch_ptr)
	delete     in_PREDICT_INST_IFETCH_PTR            ;
// 	delete     in_PREDICT_BRANCH_IS_CURRENT          ;
	delete     in_PREDICT_BRANCH_STATE               ;
	if (_param->_have_port_depth)
	delete     in_PREDICT_BRANCH_UPDATE_PREDICTION_ID;
	delete     in_EVENT_VAL                          ;
	delete    out_EVENT_ACK                          ;
	delete     in_EVENT_ADDRESS                      ;
	delete     in_EVENT_ADDRESS_NEXT                 ;
	delete     in_EVENT_ADDRESS_NEXT_VAL             ;
	delete     in_EVENT_IS_DS_TAKE                   ;
      
        // ~~~~~[ Internal ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
        if (usage_is_set(_usage,USE_SYSTEMC))
          {
            delete reg_PC_ACCESS_INSTRUCTION_ENABLE ;
            delete reg_PC_CURRENT_INSTRUCTION_ENABLE;
            delete reg_PC_NEXT_INSTRUCTION_ENABLE   ;
          }
      }


    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
    delete _component;

    log_printf(FUNC,Address_management,FUNCTION,"End");
  };

}; // end namespace address_management
}; // end namespace ifetch_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
