#ifdef VHDL

/*
 * $Id: Vhdl_set_constant.cpp 95 2008-12-16 16:24:26Z rosiere $
 *
 * [Description ]
 * 
 */

#include "Behavioural/include/Vhdl.h"

#include <sstream>

namespace morpheo              {
namespace behavioural          {
  
#undef  FUNCTION
#define FUNCTION "Vhdl::set_constant"
  void Vhdl::set_constant (std::string      name     ,
			   std::string      type     ,
			   std::string      init)
  {
    log_printf(FUNC,Behavioural,FUNCTION,"Begin");
    set_list(_list_type, "constant "+ name+"\t: "+type+"\t:= "+init);
    log_printf(FUNC,Behavioural,FUNCTION,"End");
  };

  void Vhdl::set_constant (std::string      name     ,
			   uint32_t         size     ,
			   std::string      init)
  {
    log_printf(FUNC,Behavioural,FUNCTION,"Begin");
    set_constant(name,std_logic(size),init);
    log_printf(FUNC,Behavioural,FUNCTION,"End");
  };

  void Vhdl::set_constant (std::string name     ,
			   uint32_t    size     ,
			   uint32_t    init)
  {
    log_printf(FUNC,Behavioural,FUNCTION,"Begin");
    set_constant(name,std_logic(size),std_logic_cst(size,init));
    log_printf(FUNC,Behavioural,FUNCTION,"End");
  };
  
}; // end namespace behavioural          
}; // end namespace morpheo              

#endif
