#ifdef SYSTEMC
/*
 * $Id: Front_end_Glue_genMealy_branch_complete.cpp 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Front_end_Glue/include/Front_end_Glue.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace front_end_glue {

#undef  FUNCTION
#define FUNCTION "Front_end_Glue::genMealy_branch_complete"
  void Front_end_Glue::genMealy_branch_complete (void)
  {
    log_begin(Front_end_Glue,FUNCTION);

    for (uint32_t i=0; i<_param->_nb_inst_branch_complete; ++i)
      {
        Tcontrol_t miss_prediction = PORT_READ(in_BRANCH_COMPLETE_PREDICTION_UNIT_MISS_PREDICTION [i]);
        PORT_WRITE(out_BRANCH_COMPLETE_MISS_PREDICTION               [i],miss_prediction);
        PORT_WRITE(out_BRANCH_COMPLETE_CONTEXT_STATE_MISS_PREDICTION [i],miss_prediction);

        Tcontrol_t val = PORT_READ(in_BRANCH_COMPLETE_VAL [i]);
        PORT_WRITE(out_BRANCH_COMPLETE_PREDICTION_UNIT_VAL [i],val);
        PORT_WRITE(out_BRANCH_COMPLETE_CONTEXT_STATE_VAL   [i],val);

        Tcontrol_t ack = (PORT_READ(in_BRANCH_COMPLETE_PREDICTION_UNIT_ACK [i]) and
                          PORT_READ(in_BRANCH_COMPLETE_CONTEXT_STATE_ACK   [i]));
        PORT_WRITE(out_BRANCH_COMPLETE_ACK [i],ack);      
      }

    log_end(Front_end_Glue,FUNCTION);
  };

}; // end namespace front_end_glue
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
