/*
 * $Id: Debug.cpp 100 2009-01-08 13:06:27Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Common/include/Debug.h"
#include "Common/include/Environment.h"

namespace morpheo {

#ifdef DEBUG
static bool       debug_initialized;
#endif
debug_verbosity_t debug;
bool              debug_cycle_test;
double            debug_cycle_start;
double            debug_cycle_stop ;

#undef  FUNCTION
#define FUNCTION "debug_init"
void debug_init (void)
{
#ifdef DEBUG
  if (not debug_initialized)
    {
      debug = DEBUG;
      debug_cycle_test = false;
//    debug_initialized = true;
    }
#endif
}

#undef  FUNCTION
#define FUNCTION "debug_init"
void debug_init (debug_verbosity_t level,
                 double            cycle_start,
                 double            cycle_stop )
{
#ifdef DEBUG
  if (not debug_initialized)
    {
      // Take min
      debug = (level < DEBUG)?level:DEBUG;
     
#ifdef SYSTEMC
      debug_cycle_test  = (cycle_stop > cycle_start) or (cycle_stop == -1);
      debug_cycle_start = cycle_start;
      debug_cycle_stop  = cycle_stop;
#else
      debug_cycle_test = false;
#endif

      debug_initialized = true;
    }
#endif
}

}; // end namespace morpheo
