#include <iostream>
#include "../include/Endianness.h"

using namespace std;
using namespace environment;
using namespace environment::endianness;

#ifdef SYSTEMC
int sc_main (int argc, char * argv[])
#else
int    main (int argc, char * argv[])
#endif
{
  cout << "<main> Begin" << endl;

  cout << "hostEndianness : " << hostEndianness() << endl;
  cout << "cpuEndianness  : " << cpuEndianness (0) << endl;
  cout << "same ?         : " << isSameEndianness (0) << endl;

  char * str = new char [16];

  str [0] = 'a';
  for (uint32_t i=1; i<16; i++)
    str [i] = str[i-1]+1;

  cout << "str : ";
  for (uint32_t i=0; i<16; i++)
    cout << str [i];
  cout << endl;

  str = swapBytes (str, 16, 4);

  cout << "str : ";
  for (uint32_t i=0; i<16; i++)
    cout << str [i];
  cout << endl;

  str = swapBytes (str, 16, 1);

  cout << "str : ";
  for (uint32_t i=0; i<16; i++)
    cout << str [i];
  cout << endl;

  str = swapBytes (str, 16, 8);

  cout << "str : ";
  for (uint32_t i=0; i<16; i++)
    cout << str [i];
  cout << endl;

  str = swapBytes (str, 16, 4);

  cout << "str : ";
  for (uint32_t i=0; i<16; i++)
    cout << str [i];
  cout << endl;

  delete [] str;
  

  cout << "<main> End" << endl;
  
  return EXIT_SUCCESS;
}
